package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.DailyOrderStatistics;
import com.xxfc.platform.order.mapper.DailyOrderStatisticsMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/**
 * 每日租车订单统计和保存
 * @author Administrator
 */
@Slf4j
@Service
public class DailyOrderStatisticsBiz extends BaseBiz<DailyOrderStatisticsMapper, DailyOrderStatistics> {

    @Autowired
    private  DailyVehicleOrderStatisticsBiz vehicleStatisticsBiz;

    @Autowired
    private DailyTravelOrderStatisticsBiz travelStatisticsBiz;

    @Autowired
    private DailyMembersOrderStatisticsBiz membersStatisticsBiz;

    @Scheduled(cron = "0 0 2 * * ?")
    public boolean statisticalOrder(){
        boolean vehicleFlag = vehicleStatisticsBiz.saveDailyVehicleOrderRecord();
        boolean travelFlag = travelStatisticsBiz.saveDailyTravelOrderRecord();
        boolean membersFlag= membersStatisticsBiz.saveDailyMembersOrderRecord();
        if (vehicleFlag&&travelFlag&&membersFlag){
            log.info("----statisticalOrder:成功-----");
            return true;
        }
        log.info("----statisticalOrder:失败-----");
        return false;
    }

}
