package com.xxfc.platform.universal.controller;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.biz.DictionaryBiz;
import com.xxfc.platform.universal.entity.Dictionary;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "dictionary")
@Api(value = "数据字典")
public class DictionaryController {

    @Autowired
    DictionaryBiz dictionaryBiz;

    @PostMapping(value = "/add")
    @ApiOperation(value = "添加数据")
    public ObjectRestResponse add(@RequestBody Dictionary dictionary) {
        return dictionaryBiz.add(dictionary);
    }

    @GetMapping(value = "/get")
    @ApiOperation(value = "获取数据")
    public ObjectRestResponse<List<Dictionary>> get(Dictionary dictionary) {
        return dictionaryBiz.get(dictionary);
    }

    @DeleteMapping(value = "/delete")
    @ApiOperation(value = "删除数据")
    public ObjectRestResponse<?> delete(Dictionary dictionary) {
        return dictionaryBiz.deleteByEntity(dictionary);
    }

    @PostMapping(value = "/update")
    @ApiOperation(value = "修改数据")
    public ObjectRestResponse<?> update(@RequestBody  Dictionary dictionary) {
        return dictionaryBiz.update(dictionary);
    }

    @GetMapping(value = "/getParents")
    @ApiOperation(value = "获取所有的父类元素 pid=0")
    public ObjectRestResponse<List<Dictionary>> getParent(String type) {
        return dictionaryBiz.getParent(type);
    }

    @GetMapping(value = "/getAll4Map")
    @ApiOperation(value = "获取所有的内容， key为 <type>_<code>")
    public ObjectRestResponse<Map<String, Dictionary>> getAll4Map() {
        return ObjectRestResponse.succ(dictionaryBiz.getAll4Map());
    }

    @GetMapping(value = "/app/unauth/clearCache")
    @ApiOperation(value = "清除缓存")
    @IgnoreUserToken
    public ObjectRestResponse clearCache() {
        dictionaryBiz.clear();
        return ObjectRestResponse.succ();
    }
}
