package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.OrderRefundBiz;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.OrderRefund;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.universal.constant.DictionaryKey;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;

@Controller
@RequestMapping("orderRefund")
public class OrderRefundController extends BaseController<OrderRefundBiz,OrderRefund> implements UserRestInterface {

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    @RequestMapping(value = "/price/calculate/{type}/{no}", method = RequestMethod.GET)
    @ResponseBody
    @IgnoreClientToken
    public ObjectRestResponse getPriceCalculate(@PathVariable(value = "type") String type, @PathVariable(value = "no") String no) {
        checkAppUser();
        //根据no 查订单
        OrderPageVO orderPageVO = baseOrderBiz.pageByParm(new Query(new PageParam(){{
            setLimit(1);
            setPage(1);
        }}){{put("no", no); }}.getSuper()).get(0);

        OrderRefundPriceVO orp = new OrderRefundPriceVO(){{
            setRealAmount(orderPageVO.getRealAmount());
        }};

        OrderTypeEnum orderTypeEnum = OrderTypeEnum.get(orderPageVO.getType());

        switch (orderTypeEnum) {
            case RENT_VEHICLE:
                baseOrderBiz.calculateRefund(orderPageVO.getGoodsAmount()
                        , System.currentTimeMillis() - orderPageVO.getOrderRentVehicleDetail().getStartTime()
                        , DictionaryKey.APP_ORDER+ "_"+ DictionaryKey.RENT_REFUND
                        , "取消订单退款:");
                break;
            case TOUR:
//                String dicParentKey = DictionaryKey.APP_ORDER+ "_"+ DictionaryKey.TOUR_REFUND;
//                //不是省外，
//                if(SYS_FALSE.equals(orderPageVO.getOrderTourDetail().getIsOutside())) {
//                    dicParentKey = DictionaryKey.APP_ORDER+ "_"+ DictionaryKey.TOUR_IN_REFUND;
//                }
//                orp.setRefundAmount(baseOrderBiz.calculateRefund(orderPageVO.getGoodsAmount().subtract(orderPageVO.getCouponAmount())
//                        , System.currentTimeMillis() - orderPageVO.getOrderRentVehicleDetail().getStartTime()
//                        , DictionaryKey.APP_ORDER+ "_"+ DictionaryKey.RENT_REFUND
//                        , "取消订单退款:"));
                break;
            default:
//                orp.setRefundAmount(orderPageVO);
                break;
        }

        return null;
    }

    @Data
    public class OrderRefundPriceVO {
        BigDecimal refundAmount;
        BigDecimal realAmount;
        BigDecimal cutAmount;

        public void setRefundAmount(BigDecimal refundAmount) {
            this.refundAmount = refundAmount;
            this.cutAmount = realAmount.multiply(refundAmount);
        }
    }
}