package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.dto.WalletFindDTO;
import com.github.wxiaoqi.security.admin.dto.WalletListDTO;
import com.github.wxiaoqi.security.admin.entity.MyWallet;
import com.github.wxiaoqi.security.admin.mapper.MyWalletMapper;
import com.github.wxiaoqi.security.admin.vo.AppletWalletVo;
import com.github.wxiaoqi.security.admin.vo.WalletPageVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 9:18
 */
@Transactional
@Service
public class MyWalletBiz extends BaseBiz<MyWalletMapper, MyWallet> {

       @Autowired
       private MyWalletDetailBiz myWalletDetailBiz;

       @Autowired
       private MyWalletCathBiz  myWalletCathBiz;

    public AppletWalletVo findMyWallet(Integer userId) {

        AppletWalletVo appletWalletVo = new AppletWalletVo();

        Example example = new Example(MyWallet.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId", userId);
        List<MyWallet> wallets = mapper.selectByExample(example);

        MyWallet myWallet = wallets.get(0);
        appletWalletVo.setBalance(myWallet.getBalance()==null?new BigDecimal(0):myWallet.getBalance());
        appletWalletVo.setTodayAmount(myWallet.getTodayAmount()==null?new BigDecimal(0):myWallet.getTodayAmount());
        appletWalletVo.setTotalAmount(myWallet.getTotalAmount()==null?new BigDecimal(0):myWallet.getTotalAmount());
        appletWalletVo.setUnbooked(myWallet.getUnbooked()==null?new BigDecimal(0):myWallet.getUnbooked());
        appletWalletVo.setUserId(myWallet.getUserId());
        return appletWalletVo;
    }

    public PageDataVO<WalletPageVo> listWalletWithPage(WalletFindDTO walletFindDTO) {

         PageDataVO<WalletPageVo> walletPageVo = new PageDataVO<>();
        PageDataVO<WalletListDTO> walletPage = PageDataVO.pageInfo(walletFindDTO.getPage(), walletFindDTO.getLimit(), () -> mapper.selectByPhoneOrUserName(walletFindDTO.getPhone(), walletFindDTO.getUsername()));
        List<WalletListDTO> wallets = walletPage.getData();
        if(CollectionUtils.isEmpty(wallets)){
            return walletPageVo;
        }

        List<Integer> userIds = wallets.stream().map(WalletListDTO::getUserId).collect(Collectors.toList());
        Map<Integer, BigDecimal> userIdAndTotalConsumptionMap = myWalletDetailBiz.finduserIdAndPersonalTotalConsumptionMapByUserIds(userIds);
        Map<Integer,BigDecimal> userIdAndWithdrawalingMap = myWalletCathBiz.findUserIdAndWithdrawalingMapByUserIds(userIds);

        List<WalletPageVo> walletPageVos = new ArrayList<>();
        WalletPageVo walletpg ;
        for (WalletListDTO wallet : wallets) {
            walletpg = new WalletPageVo();
            BeanUtils.copyProperties(wallet,walletpg);
            walletpg.setUsername(StringUtils.isEmpty(wallet.getRealname())?wallet.getNickname():wallet.getRealname());
            walletpg.setPhone(wallet.getUsername());

            BigDecimal totalConsumpution =  userIdAndTotalConsumptionMap==null?new BigDecimal(0):userIdAndTotalConsumptionMap.get(wallet.getUserId())==null?new BigDecimal(0):userIdAndTotalConsumptionMap.get(wallet.getUserId());
            BigDecimal withDrawaling  = userIdAndWithdrawalingMap==null?new BigDecimal(0):userIdAndWithdrawalingMap.get(wallet.getUserId())==null?new BigDecimal(0):userIdAndWithdrawalingMap.get(wallet.getUserId());
            walletpg.setWithdrawaling(withDrawaling);
            walletpg.setWithdrawals(walletpg.getWithdrawals()==null?new BigDecimal(0):walletpg.getWithdrawals());
            walletpg.setUnbooked(walletpg.getUnbooked()==null?new BigDecimal(0):walletpg.getUnbooked());
            walletpg.setTotalAmount(walletpg.getTodayAmount()==null?walletpg.getUnbooked():walletpg.getTotalAmount().add(walletpg.getUnbooked()));
            walletpg.setTotalConsumption(totalConsumpution);
            walletPageVos.add(walletpg);
        }



        walletPageVos.sort(Comparator.comparing(WalletPageVo::getTotalAmount).reversed());
        walletPageVo.setPageNum(walletFindDTO.getPage());
        walletPageVo.setPageSize(walletFindDTO.getLimit());
        walletPageVo.setTotalCount(walletPage.getTotalCount());
        walletPageVo.setTotalPage(walletPage.getTotalPage());
        walletPageVo.setData(walletPageVos);
        return walletPageVo;
    }
}
