package com.xxfc.platform.order.contant.enumerate;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.WeekFields;
import java.util.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/14 14:28
 */
public enum  StatisticsStatusEnum {
    ;
    public static final int DEFAULT_COMPANY=1;
    public static final int ORDER_MEMBER_TYPE=3;
    public static final int ORDER_RENT_VEHICLE_TYPE=1;
    public static final int ORDER_TOUR_TYPE=2;
    public static final int NO_PAY_WAY=0;
    public static final Integer DEFAULT_SQL_SIZE=1000;
    public static final String ORDER_AMOUNT="order_amount";
    public static final String LATEFEE_AMOUNT="late_fee";
    public static final String ORDER_REFUND_AMOUNT="order_refund_amount";
    public static final String ORDER_DEPOSIT_AMOUNT="order_deposit_amount";
    public static final String COMPANY_DEFAULT="欣新房车控股集团";
    public static final String NO_DEDUCTIBLE_AMOUNT="damageSafeAmount";
    public static final String  PARMAM_JSON="paramJson";
    public static final int DAMAGE_SAFE=1;
    public static List<String> orderStates;
    public static List<String> orderOrigins;
    public static List<String> orderPayWays;

    static {
         // 0 未支付 1 已支付
        orderStates = Lists.newArrayList("0","1");
        // 1 app   2 小程序  3 其他
        orderOrigins = Lists.newArrayList("1","2","3");
        // 1 微信  2 支付宝  0不需要支付(使用了优惠券之类的)或未支付
        orderPayWays = Lists.newArrayList("1","2","0");
    }

    public static List<String> statisticsSateGroupWithCompanys(List<Integer> companyIdList){
        List<String> orderStatisticsStateGroups = new ArrayList<>();
        List<String> stateGroup = statisticsStateGroup();
        for (String stgp : stateGroup) {
            for (Integer companyId : companyIdList) {
                 // 公司id-订单来源-支付方式-订单状态
                orderStatisticsStateGroups.add(String.format("%d-%s",companyId,stgp));
            }
        }
        return orderStatisticsStateGroups;
    }

    public static List<String> statisticsStateGroup(){
        List<String> orderStatisticsStateGroups = new ArrayList<>();
        for (String orderOrigin : orderOrigins) {
            for (String orderPayWay : orderPayWays) {
                for (String orderState : orderStates) {
                    //订单来源-支付方式-订单状态
                    orderStatisticsStateGroups.add(String.format("%s-%s-%s",orderOrigin,orderPayWay,orderState));
                }
            }
        }
        return orderStatisticsStateGroups;
    }
    public static List<String> getOtherStatisticsStateGroup(List<Integer> companyIdList,List<String> statisticsStates){
        List<String> stateGroupList = CollectionUtils.isEmpty(companyIdList)?statisticsStateGroup():statisticsSateGroupWithCompanys(companyIdList);
        stateGroupList.removeAll(statisticsStates);
        return stateGroupList;
    }

    public static<T extends OrderReceivedStatisticsBase> T wrapStatisticsObject(Date date, String stateGroup, Map<Integer,String> companyMap, T targetObj){
        LocalDate localDate =  LocalDate.from(new Date().toInstant().atZone(ZoneId.systemDefault()));
        String year = String.valueOf(localDate.getYear());
        String month = String.format("%s%d", year, localDate.getMonthValue());
        String weekOfYear = String.format("%s%d", year,localDate.get(WeekFields.of(Locale.CHINESE).weekOfYear()));
        String[] status = stateGroup.split("-");
        targetObj.setCrtTime(new Date());
        targetObj.setCompanyId(Integer.valueOf(status[0]));
        String companyName = Objects.isNull(companyMap)?COMPANY_DEFAULT: StringUtils.hasText(companyMap.get(targetObj.getCompanyId()))?companyMap.get(targetObj.getCompanyId()):COMPANY_DEFAULT;
        targetObj.setCompanyName(companyName);
        targetObj.setHasPay(Integer.valueOf(status[3]));
        targetObj.setOrderOrigin(Integer.valueOf(status[1]));
        targetObj.setPayWay(Integer.valueOf(status[2]));
        targetObj.setDate(date);
        targetObj.setYear(year);
        targetObj.setMonth(month);
        targetObj.setWeekOfYear(weekOfYear);
        targetObj.setExtraAmount(BigDecimal.ZERO);
        targetObj.setLateFeeAmount(BigDecimal.ZERO);
        targetObj.setTotalAmount(BigDecimal.ZERO);
        targetObj.setTotalQuantity(0);
        targetObj.setOrderRefundAmount(BigDecimal.ZERO);
        targetObj.setStateGroup(stateGroup);
        return targetObj;
    }
}
