package com.xxfc.platform.app.biz;

import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.app.entity.Banner;
import com.xxfc.platform.app.entity.vo.BannerVo;
import com.xxfc.platform.app.mapper.BannerMapper;
import org.springframework.stereotype.Service;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description TODO
 * @data 2019/6/26 9:24
 */
@Service
public class BannerBiz extends BaseBiz<BannerMapper,Banner> {

    public List<BannerVo> findBannerList(Integer type,Integer location,Integer platform) {
        List<BannerVo> bannerVos = new ArrayList<>();
        List<Banner> banners = mapper.findBannerListByType(type,location,platform);
        banners.forEach(banner -> {
            BannerVo bannerVo = new BannerVo();
            bannerVo.setCover(banner.getCover());
            bannerVo.setUrl(banner.getUrl());
            bannerVo.setTitle(banner.getTitle());
            bannerVo.setId(banner.getId());
            bannerVo.setAlt(banner.getAlt());
            bannerVos.add(bannerVo);
        });
        return bannerVos;
    }

    /**
     * 分页查询banner
     * @param pageNo
     * @param pageSize
     * @return
     */
    public PageDataVO<Banner> findBannePage(Integer pageNo, Integer pageSize,Integer platform) {
        return  PageDataVO.pageInfo(pageNo, pageSize, () -> mapper.findBannerListByisDelOrderByRank(Banner.builder().isDel(0).platform(platform).build()));
    }

    /**
     * 保存或更新banner
     * @param banner
     * @param userInfo
     * @return
     */
    public int save(Banner banner, UserDTO userInfo) {
        if (banner.getId()!=null){
            banner.setUpdName(userInfo.getUsername());
            banner.setUpdTime(Instant.now().toEpochMilli());
            return mapper.updateByPrimaryKeySelective(banner);
        }else {
            banner.setCrtName(userInfo.getUsername());
            banner.setCrtTime(Instant.now().toEpochMilli());
            banner.setIsDel(0);
            banner.setRank(banner.getRank()==null?0:banner.getRank());
            return mapper.insertSelective(banner);
        }
    }

    /**
     * 逻辑删除
     * @param id
     * @param status
     * @param userInfo
     * @return
     */
    public int updateBannerStatus(Integer id, int status, UserDTO userInfo) {
        return  mapper.updateByPrimaryKeySelective(Banner.builder().id(Long.valueOf(id)).isDel(status).updName(userInfo.getUsername()).updTime(Instant.now().toEpochMilli()).build());
    }
}
