package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.biz.ActivityBiz;
import com.xxfc.platform.activity.biz.ActivityTypeBiz;
import com.xxfc.platform.activity.dto.ActivityDTO;
import com.xxfc.platform.activity.entity.Activity;
import com.xxfc.platform.activity.vo.ActivityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("app/activity")
public class ActivityController extends BaseController<ActivityBiz, Activity> {


    @Autowired
    ActivityTypeBiz activityTypeBiz;



    @GetMapping("app/unauth/selectList")
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<ActivityVo>> selectList( ActivityDTO activityDTO) {
        return baseBiz.getAllByPage(activityDTO);
    }



    @GetMapping("app/unauth/typeList")
    @IgnoreUserToken
    public ObjectRestResponse typeList() {
        return ObjectRestResponse.succ(activityTypeBiz.getList());
    }

}