package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.BranchCompanyBiz;
import com.github.wxiaoqi.security.admin.biz.CompanyInfoBiz;
import com.github.wxiaoqi.security.admin.dto.CompanySearchDTO;
import com.github.wxiaoqi.security.admin.entity.BranchCompany;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.admin.vo.CompanySearchVO;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/branchCompany")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"店铺"})
public class AdminBranchCompanyController extends BaseController<BranchCompanyBiz, BranchCompany> implements UserRestInterface {


    @Autowired
    CompanyInfoBiz companyInfoBiz;

    @Autowired
    UserFeign userFeign;


    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }


    @GetMapping("search")
    @ApiModelProperty("店铺列表")
    public  ObjectRestResponse search(CompanySearchDTO companySearchDTO) {
     return ObjectRestResponse.succ( baseBiz.search(companySearchDTO));
    }



    @PostMapping("addOrUpd")
    @ApiModelProperty("店铺更新")
    public  ObjectRestResponse addOrUpd(@RequestBody BranchCompany branchCompany) {
        return baseBiz.addOrUpd(branchCompany);
    }

    @GetMapping("info")
    @ApiModelProperty("店铺信息")
    public  ObjectRestResponse search() {
        CompanySearchDTO companySearchDTO=new CompanySearchDTO();
        setPowerData(companySearchDTO);
        List<CompanySearchVO> list = baseBiz.getList(companySearchDTO);
        if (list.size() == 0){
            throw  new BaseException("店铺不存在", ResultCode.FAILED_CODE);
        }
        return ObjectRestResponse.succ(list.get(0));
    }




}
