package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.service.TrafficViolationsService;
import com.xxfc.platform.universal.vo.TrafficViolations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("3p/tv")
public class TrafficViolationsController {

    @Autowired
    TrafficViolationsService tvService;

    /**
     * 获取支持的城市
     * @return
     */
    @GetMapping("/city")
    public ObjectRestResponse getCityInfo() {
        try {
            return  ObjectRestResponse.succ(JSONObject.parse(tvService.getCity()));
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createDefaultFail();
        }
    }

    /**
     * 违章车辆查询
     * @return
     */
    @PostMapping("/trafficViolations")
    public ObjectRestResponse queryTrafficViolations(@RequestBody TrafficViolations trafficViolations) {
        try {
            return ObjectRestResponse.succ(JSONObject.parse(tvService.queryViolations(trafficViolations)));
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createDefaultFail();
        }
    }

    /**
     * 车辆类型查询
     * @return
     */
    @GetMapping("/LicensePlateType")
    public ObjectRestResponse getLicensePlateType() {
        try {
            return ObjectRestResponse.succ(tvService.getLicensePlateType());
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createDefaultFail();
        }
    }




}
