package com.xxfc.platform.universal.feign;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.entity.OrderRefund;
import com.xxfc.platform.universal.vo.OrderPayVo;
import com.xxfc.platform.universal.vo.OrderRefundVo;
import com.xxfc.platform.universal.vo.TrafficViolations;
import feign.Param;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-universal")
public interface ThirdFeign {
    @RequestMapping(value = "/sms/app/unauth/send", method = RequestMethod.GET)
    public JSONObject send(@RequestParam(value = "phone") String phone);
    @RequestMapping(value = "/file/app/unauth/uploadFiles", method = RequestMethod.POST)
    public JSONObject uploadFiles(@RequestParam(value = "files") MultipartFile[] files);
    @RequestMapping(value = "/pay/app/wx", method = RequestMethod.POST)
    public JSONObject wx(@RequestBody OrderPayVo orderPayVo);
    @RequestMapping(value = "/refund/app/wx", method = RequestMethod.POST)
    public ObjectRestResponse<String> refund(@RequestBody OrderRefundVo orderRefundVo);

    /**
     * 获取支持的城市
     * @return
     */
    @GetMapping("/city")
    ObjectRestResponse getCityInfo();

    /**
     * 违章车辆查询
     * @return
     */
    @PostMapping("/trafficViolations")
    ObjectRestResponse queryTrafficViolations(@RequestBody TrafficViolations trafficViolations) ;

    /**
     * 车辆类型查询
     * @return
     */
    @GetMapping("/LicensePlateType")
    ObjectRestResponse getLicensePlateType();


    /*****************************************  数据字典 ********************************************/


//    @GetMapping(value = "/dictionary/getParents")
    @RequestMapping(value = "/dictionary/getParents", method = RequestMethod.GET)
    public ObjectRestResponse<List<Dictionary>> dictionaryGetParent(@RequestParam(value = "type") String type);

//    @GetMapping(value = "/dictionary/get")
    @RequestMapping(value = "/dictionary/get", method = RequestMethod.GET)
    public ObjectRestResponse<List<Dictionary>> dictionaryGet(@RequestParam(value = "dictionary") Map<String, Object> dictionary);
}
