package com.xxfc.platform.campsite.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.campsite.biz.CampsiteShopBiz;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopAdminFindDTO;
import com.xxfc.platform.campsite.entity.CampsiteShop;
import com.xxfc.platform.campsite.vo.CampsiteShopAdminPageVo;
import com.xxfc.platform.campsite.vo.CampsiteShopAdminVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description 营地店铺
 * @data 2019/6/17 13:37
 */
@RestController
@RequestMapping("/admin/campsiteShop")
@Api(tags = "后台营地店铺")
public class CampsiteShopAdminController extends BaseController<CampsiteShopBiz,CampsiteShop> {


    @ApiOperation(value = "营地列表")
    @PostMapping("/pages")
    public ObjectRestResponse<PageDataVO<CampsiteShopAdminPageVo>> findCampsiteShopPage(@RequestBody CampsiteShopAdminFindDTO campsiteShopAdminFindDTO){
        PageDataVO<CampsiteShopAdminPageVo> pageVoPageDataVO = getBaseBiz().findCampsiteShopPage(campsiteShopAdminFindDTO);
        return ObjectRestResponse.succ(pageVoPageDataVO);
    }


    @ApiOperation("营地保存")
    @PostMapping("/save")
    public ObjectRestResponse<Void> saveCampistieShop(@RequestBody CampsiteShopAdminDTO campsiteShopAdminDTO){
        int effectRows = getBaseBiz().saveCampsiteShop(campsiteShopAdminDTO);
        if (effectRows>0){
         return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @ApiOperation("逻辑删除")
    @Override
    public ObjectRestResponse<CampsiteShop> remove(@PathVariable(value = "id") int id) {
        int effectRows = getBaseBiz().updateCampsiteSatus(id);
        if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return  ObjectRestResponse.createDefaultFail();
    }

    @ApiOperation("营地上下架")
    @PutMapping("/saleStatus")
    public ObjectRestResponse<Void> updateSaleStatus(@RequestParam("id") Integer id,@RequestParam("status") Integer status){
        int effectRows = getBaseBiz().updateCampsiteSaleStatus(id,status);
        if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return  ObjectRestResponse.createDefaultFail();
    }

    @ApiOperation("检验营地名称")
    @GetMapping("/exist")
    public ObjectRestResponse<Boolean> checkCampsiteNameExist(@RequestParam(value = "id",required = false) Integer id,@RequestParam("name") String name){
        Boolean exist =  getBaseBiz().chekcCampsiteNameExist(id,name==null?"":name.trim());
        return ObjectRestResponse.succ(exist);
    }

    @ApiOperation("营地编辑查询")
    @GetMapping("/campsite/{id}")
    public ObjectRestResponse<CampsiteShopAdminVO> findByCampsiteId(@PathVariable(value = "id") Integer id){
          CampsiteShopAdminVO campsiteShopAdminVO = getBaseBiz().findByCampsiteId(id);
          return ObjectRestResponse.succ(campsiteShopAdminVO);
    }
}