package com.github.wxiaoqi.security.admin.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.User;
import com.github.wxiaoqi.security.admin.mapper.AppUserLoginMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.constant.UserConstant;
import com.github.wxiaoqi.security.common.msg.TableResultResponse;
import com.github.wxiaoqi.security.common.util.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import static com.github.wxiaoqi.security.auth.common.constatns.CommonConstants.DATA_ALL_TRUE;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 16:23
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class AppUserLoginBiz extends BaseBiz<AppUserLoginMapper, AppUserLogin> {


    @Override
    public void insertSelective(AppUserLogin entity) {
        String password = new BCryptPasswordEncoder(UserConstant.PW_ENCORDER_SALT).encode(entity.getPassword());
        entity.setPassword(password);
        super.insertSelective(entity);
    }

    @Override
    @CacheClear(pre="user{1.username}")
    public void updateSelectiveById(AppUserLogin entity) {
        super.updateSelectiveById(entity);
    }

    @CacheClear(pre="user{1.username}")
    public void updatePasswordById(AppUserLogin entity) {
        String password = new BCryptPasswordEncoder(UserConstant.PW_ENCORDER_SALT).encode(entity.getPassword());
        entity.setPassword(password);
        super.updateSelectiveById(entity);
    }


    /**
     * 根据用户名获取用户信息
     * @param username
     * @return
     */
    @Cache(key="user{1}")
    public AppUserLogin getUserByUsername(String username){
        AppUserLogin user = new AppUserLogin();
        user.setUsername(username);
        return mapper.selectOne(user);
    }

   /* public TableResultResponse<AppUserLogin> selectPage(Query query, AppUserLogin currentUser) {
        if(DATA_ALL_TRUE.equals(currentUser.getDataAll())) {
            return super.selectByQuery(query);
        }else {
            Example example = new Example(User.class);
            if(query.entrySet().size()>0) {
                Example.Criteria criteria = example.createCriteria();
                for (Map.Entry<String, Object> entry : query.entrySet()) {
                    criteria.andLike(entry.getKey(), "%" + entry.getValue().toString() + "%");
                }
            }
            if(StringUtils.isNotBlank(currentUser.getDataCompany())){
                example.createCriteria().andIn("companyId", Arrays.asList(currentUser.getDataCompany().split(",")));
            }
            if(StringUtils.isNotBlank(currentUser.getDataZone())){
                example.createCriteria().andIn("zoneId", Arrays.asList(currentUser.getDataZone().split(",")));
            }
            Page<Object> result = PageHelper.startPage(query.getPage(), query.getLimit());
            List<User> list = mapper.selectByExample(example);
            return new TableResultResponse<User>(result.getTotal(), list);
        }
    }*/

    /**
     * 根据手机号码判断是否存在用户
     *
     * @param username
     * @return
     * @throws Exception
     */

    public AppUserLogin checkeUserLogin(String username) {
        Example example = new Example(AppUserLogin.class);
        example.createCriteria().andEqualTo("username", username).andEqualTo("isdel", 0).andEqualTo("status",0);
        List<AppUserLogin> userLoginList = mapper.selectByExample(example);
        if (userLoginList != null && userLoginList.size() != 0) {
            return userLoginList.get(0);
        }
        return null;
    }

    /**
     * 根据微信号判断是否存在用户
     * @param openid
     * @return
     */
    public AppUserLogin getUserByOpenid(String openid,Integer isQQ) {
        Example example = new Example(AppUserLogin.class);
        if(isQQ==1){
            example.createCriteria().andEqualTo("openid", openid).andEqualTo("isdel", 0);
        }else {
            example.createCriteria().andEqualTo("wxOpenid", openid).andEqualTo("isdel", 0);
        }
        List<AppUserLogin> userLoginList = mapper.selectByExample(example);
        if (userLoginList != null && userLoginList.size() != 0) {
            return userLoginList.get(0);
        }
        return null;
    }

    /**
     * 根据手机号码判断是否已绑定微信
     *
     * @param userLogin
     * @return
     */
    public boolean checkeWechatUser(AppUserLogin userLogin) {
        boolean flag = true;
        if (null != userLogin) {
            Integer userid = userLogin.getId();
             userLogin= mapper.selectByPrimaryKey(userid);
                if (userLogin==null) {
                    flag = false;
            }
        }
        return flag;
    }

    //获取用户信息
    public AppUserLogin getUserById(Integer userId){
        return mapper.selectByPrimaryKey(userId);
    }
}
