package com.xxfc.platform.order.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 每日统计
 * @author Administrator
 */
@Data
public class DailyOrderStatistics implements Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(generator = "JDBC")
    private Integer id;

    /**
     * 日期
     */
    @Column(name = "one_day")
    private  String oneDay;

    /**
     * 分公司id
     */
    @Column(name = "branch_company_id")
    private  Integer branchCompanyId;


    /**
     * 成交总金额
     */
    @Column(name = "gmv")
    private BigDecimal gmv;


    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date crtTime;
}
