package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum RefundStatusEnum {
    NONE(0, "未退还"),
    ALL(1, "已退还所有钱"),
    RESIDUE_ILLEGAL(2, "已退还部分押金（保留违章预备金）"),
    REFUND_DEPOSIT(3, "已退还所有押金（扣除该扣除的）"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    RefundStatusEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}