package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.AppUserSellingWaterBiz;
import com.github.wxiaoqi.security.admin.dto.UserSellingWaterAdminDTO;
import com.github.wxiaoqi.security.admin.dto.UserSellingWaterFindDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/21 10:10
 */
@RestController
@RequestMapping("/sellingwater/admin")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class UserSellingWaterAdminController {

     private final AppUserSellingWaterBiz appUserSellingWaterBiz;


     @PostMapping("/page")
     public ObjectRestResponse<PageDataVO<UserSellingWaterAdminDTO>> findSellingWaterWithPage(@RequestBody UserSellingWaterFindDTO userSellingWaterFindDTO){
          PageDataVO<UserSellingWaterAdminDTO> pageDataVO = appUserSellingWaterBiz.findSellingWaterWithPage(userSellingWaterFindDTO);
         return ObjectRestResponse.succ(pageDataVO);
     }
}
