package com.github.wxiaoqi.security.admin.dto;

import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * 员工变更记录表
 */
@Data
public class AppUserPositionChangeRecordDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Integer id;

    /**
     * 用户id
     */
    private String phone;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 变更后所在公司ID
     */
    private Integer newCompanyId;

    /**
     * 变更前所在公司ID
     */
    private Integer oldCompanyId;

    /**
     * 变更后所在公司名称
     */
    private String newCompanyName;

    /**
     * 变更前所在公司名称
     */

    private String oldCompanyName;

    /**
     * 旧职位ID
     */
    private Integer oldJobId;

    /**
     * 新职位ID
     */
    private Integer newJobId;

    /**
     * 新职位名称
     */
    private String newJobName;

    /**
     * 旧职位名称
     */
    private String oldJobName;

    /**
     * 操作人名称
     */
    private Integer operatorId;

    /**
     * 操作时间
     */
    private Timestamp crtTime;

    /**
     * 状态
     * 1:入职；2：职位变更；3：身份变更 4：公司所属变更；5离职
     */
    private Integer jobRemark;

    /***
     * 旧身份ID
     */
    private Integer oldPositionId;

    /***
     * 新身份ID
     */
    private Integer newPositionId;

    /***
     * 新身份名称
     */
    private String newPositionName;

    /***
     * 旧身份名称
     */
    private String oldPositionName;

    /**
     * 员工职位、所属公司、离职、入职等的实际上任时间
     */
    private Timestamp relTime;
}
