package com.xxfc.platform.vehicle.rest.admin;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.vehicle.biz.CompanyInfoBiz;
import com.xxfc.platform.vehicle.entity.CompanyInfo;
import com.xxfc.platform.vehicle.pojo.dto.CompanyInfoFindDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("company/info")
public class CompanyInfoController extends BaseController<CompanyInfoBiz,CompanyInfo> {






    @ApiOperation("查询公司列表")
    @RequestMapping(value = "/selectList", method = RequestMethod.GET)
    public ObjectRestResponse getList(CompanyInfoFindDTO companyInfoFindDTO){
        return  baseBiz.selectList(companyInfoFindDTO);
    }



    @ApiOperation("新增公司")
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public ObjectRestResponse saveCompany(@RequestBody CompanyInfo companyInfo){
          return  baseBiz.addOrUpd(companyInfo);
    }


    @ApiOperation("更新公司")
    @RequestMapping(value = "/upd", method = RequestMethod.POST)
    public ObjectRestResponse updCompany(@RequestBody CompanyInfo companyInfo){
        return  baseBiz.addOrUpd(companyInfo);
    }


    @ApiOperation("删除")
    @RequestMapping(value = "/del", method = RequestMethod.POST)
    public ObjectRestResponse delCompany(@RequestBody CompanyInfo companyInfo){
        companyInfo.setIsDel(1);
        return  baseBiz.addOrUpd(companyInfo);
    }




}
