package com.xxfc.platform.vehicle.rest.admin;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.BranchCompanyApplyBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.entity.BranchCompanyApply;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyApplyFindDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("company/apply")
public class CompanyApplyController extends BaseController<BranchCompanyApplyBiz> {






    @ApiOperation("查询入驻公司列表")
    @RequestMapping(value = "/selectList", method = RequestMethod.GET)
    public ObjectRestResponse getList(BranchCompanyApplyFindDTO applyFindDTO){
        return  baseBiz.selectList(applyFindDTO);
    }

    @ApiOperation("更新入驻公司")
    @RequestMapping(value = "/upd", method = RequestMethod.POST)
    public ObjectRestResponse updCompany(@RequestBody BranchCompanyApply branchCompanyApply){
          return  baseBiz.addOrUpd(branchCompanyApply);
    }



    @ApiOperation("新增入驻公司")
    @RequestMapping(value = "app/unauth/add", method = RequestMethod.POST)
    @IgnoreUserToken
    public ObjectRestResponse addCompany(@RequestBody BranchCompanyApply branchCompanyApply){
        return  baseBiz.addOrUpd(branchCompanyApply);
    }



}
