package com.xxfc.platform.vehicle.biz;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.google.common.collect.Lists;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.Area;
import com.xxfc.platform.vehicle.mapper.AreaMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import static com.github.wxiaoqi.security.auth.common.constatns.CommonConstants.DATA_ALL_FALSE;

@Service
public class AreaBiz extends BaseBiz<AreaMapper, Area> implements UserRestInterface {

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    public RestResponse<List<Area>> findAll() {
        UserDTO userDTO = getAdminUserInfo();
        if (userDTO == null) {
            return RestResponse.suc();
        }
        String ids = null;
        if (DATA_ALL_FALSE.equals(userDTO.getDataAll())) { //不能获取全部数据
            if (StringUtils.isNotBlank(userDTO.getDataZone())) {
                ids = userDTO.getDataZone();
            } else {
                ids = userDTO.getZoneId() + "";
            }
            if (ids.contains(",")) {
                String[] array = ids.split(",");
                List<Integer> list = Lists.newArrayList();
                for (int i = 0; i < array.length; i++) {
                    if (StringUtils.isNotBlank(array[i])) {
                        list.add(Integer.parseInt(array[i]));
                    }
                }
                return RestResponse.suc(mapper.findAllByIds(list));

            } else {
                Area area = mapper.selectByPrimaryKey(ids);
                if (Objects.isNull(area)) {
                    return null;
                }
                List<Area> areas = Lists.newArrayList();
                areas.add(area);
                return RestResponse.suc(areas);
            }
        } else { //拥有全部权限
            return RestResponse.suc(mapper.selectAll());
        }

    }


    public List<Area> findAllAreas() {
        List<Area> areas = mapper.selectAll();
        return CollectionUtils.isEmpty(areas) ? Collections.emptyList() : areas;
    }
}
