package com.xxfc.platform.app.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.app.biz.CofigBiz;
import com.xxfc.platform.app.entity.Cofig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
/**
 * @author libin
 * @version 1.0
 * @description  后台*通用配置
 * @data 2019/6/12 9:56
 */
@RestController
@RequestMapping("/admin/config")
@Slf4j
public class CofigAdminController extends BaseController<CofigBiz,Cofig> {


    /**
     * 修改通用配置
     * @param cofig
     * @return
     */
    @Override
    public ObjectRestResponse<Cofig> update(@RequestBody  Cofig cofig) {
        int rows = getBaseBiz().updateConfig(cofig);
        if (rows>0){
            return  ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }
}