package com.xxfc.platform.app.biz;

import com.alibaba.fastjson.JSON;
import com.github.wxiaoqi.security.common.util.EntityUtils;
import com.xxfc.platform.app.entity.vo.WithDrawRuleVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.mapper.CofigMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 系统配置表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-03 15:57:13
 */
@Service
public class CofigBiz extends BaseBiz<CofigMapper,Cofig> {

    public List<Cofig> getConfigByType(List<Integer> list){
        return  mapper.getAllByType(list);

    }

    /**
     * 修改配置
     * @param cofig
     * @return
     */
    public int updateConfig(Cofig cofig) {
        EntityUtils.setUpdatedInfo(cofig);
       return mapper.updateConfig(cofig);
    }

    public WithDrawRuleVo getWithDrawRule(){
        WithDrawRuleVo withDrawRuleVo = new WithDrawRuleVo();
        Example example  = new Example(Cofig.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("type",88);
        List<Cofig> cofigs = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(cofigs)){
            return withDrawRuleVo;
        }
        Cofig cofig = cofigs.get(0);
       withDrawRuleVo = JSON.parseObject(cofig.getParams(),WithDrawRuleVo.class);
       withDrawRuleVo.setDescription(cofig.getValue());
       return withDrawRuleVo;
    }
}