package com.xxfc.platform.activity.config;

import com.github.wxiaoqi.security.common.config.RabbitCommonConfig;
import com.github.wxiaoqi.security.common.config.rabbit.BindDTO;
import com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitActivityConfig extends RabbitCommonConfig {

    public static final String INTEGRAL_QUEUE = "integral_queue";
//    public static final String POPULARZIE_REGISTER_QUEUE = "popularzie.register.queue";
//    public static final String POPULARZIE_AUTH_QUEUE = "popularzie.auth.queue";
    public static final String POPULARZIE_0101_QUEUE = "popularzie.0101.queue";

    static {
        myQueue = new ArrayList<BindDTO>(){{
            add(new BindDTO(INTEGRAL_QUEUE,  RabbitConstant.ORDER_TOPIC, "order.#"));
            add(new BindDTO(POPULARZIE_0101_QUEUE,  RabbitConstant.ADMIN_TOPIC, "appUser.#"));
//            add(new BindDTO(POPULARZIE_REGISTER_QUEUE,  RabbitConstant.ADMIN_TOPIC, "appUser.register"));
//            add(new BindDTO(POPULARZIE_AUTH_QUEUE,  RabbitConstant.ADMIN_TOPIC, "appUser.login"));
        }};
    }

}

