package com.xxfc.platform.activity.vo;

import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.activity.entity.IntegralUserRecord;
import lombok.Data;

@Data
public class IntegralUserRecordDto extends PageParam {
    Integer userId;
    Long startTime;
    Long endTime;
    String integralRuleCode;
    String amount;
    /**
     * 0-获取积分；1-抵扣积分
     */
    private Integer type = 0;

    /**
     * 积分数
     */
    private Integer point;
    /**
     * 获取积分的途径id:如订单id,评论id，签到记录id
     */
    private Integer channelId;

    public IntegralUserRecord getIntegralUserRecord() {
        IntegralUserRecord integralUserRecord = new IntegralUserRecord();
        integralUserRecord.setPoint(point);
        integralUserRecord.setIntegralRuleCode(integralRuleCode);
        integralUserRecord.setChannelId(channelId);
        integralUserRecord.setIsValid(true);
        integralUserRecord.setIsdel(false);
        integralUserRecord.setUserId(userId);
        integralUserRecord.setType(type);
        return integralUserRecord;
    }
}
