package com.github.wxiaoqi.security.admin.support.aop;

import cn.hutool.core.util.ArrayUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

/**
 * @author libin
 * @version 1.0
 * @description user信息组装
 * @data 2019/6/17 13:44
 */
@Aspect
@Component
@ConditionalOnClass(value = UserFeign.class)
public class TokenAop {


    @Value("${auth.user.token-header:Authorization}")
    private String tokenHeader;

      @Resource
      private UserFeign userFeign;

    @Pointcut("execution(* com.xxfc.platform..rest..*(..))")
    public void tokenExpress(){}

    /**
     * userFeign.userDetailByToken("");  获取app用户的信息
     * userFeign.userinfoByToken("");  获取后台用户的信息
     * Todo 还有token 校验规则 ，是否过期 未加入检验 .......
     * @param proceedingJoinPoint
     * @return
     */
   @Around("tokenExpress()")
    public Object token(ProceedingJoinPoint proceedingJoinPoint) throws  Throwable{
       HttpServletRequest request = ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
       String token = request.getHeader(tokenHeader);

       Object[] args = proceedingJoinPoint.getArgs();
       if (ArrayUtil.isEmpty(args)){
            //没有参数直接返回
           return proceedingJoinPoint.proceed();
       }
       MethodSignature methodSignature = (MethodSignature) proceedingJoinPoint.getSignature();
       Method currentMethod = methodSignature.getMethod();
       Parameter[] parameters = currentMethod.getParameters();
       for(int i =0;i<args.length;i++){
           Parameter parameter = parameters[i];
           //app用户
           if (AppUserDTO.class.equals(parameter.getType())){
                //token为空
                if (StringUtils.isEmpty(token)){
                   return ObjectRestResponse.createFailedResult(4004,"token不能为空");
                }
               args[i]= userFeign.userDetailByToken(token).getData();
               break;
           }
           if (UserDTO.class.equals(parameter.getType())){
               //token为空
               if (StringUtils.isEmpty(token)){
                   return ObjectRestResponse.createFailedResult(4004,"token不能为空");
               }
               args[i]=userFeign.userinfoByToken(token).getData();
               break;
           }
       }
       return proceedingJoinPoint.proceed(args);
   }
    public void setTokenHeader(String tokenHeader) {
        this.tokenHeader = tokenHeader;
    }
}
