package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 用户详情信息表
 */
@Table(name = "app_user_detail")
@Data
public class AppUserDetail {
	@Id
	@GeneratedValue(generator = "JDBC")
	private Integer id;
	private Integer userid;
	@Column(name = "is_member")
	private Integer isMember;
	private String nickname;
	private String realname;
	private String headimgurl;
	private String email;
	private Integer sex;
	private String birthday;
	@Column(name = "person_sign")
	private String personSign;
	private String remark;
	private Long createtime;
	private Long updatetime;
	private Integer isdel;
	//渠道来源；1-app；2-小程序
	private Integer channel;
	/**
	 * 省份编号
	 */
	@Column(name = "province_code")
	private Integer provinceCode;

	/**
	 * 市编号
	 */
	@Column(name = "city_code")
	private Integer cityCode;

	/**
	 * 创建ip
	 */
	@Column(name = "crt_host")
	private  String crtHost;
	/**
	 * 更新ip
	 */
	@Column(name = "upd_host")
	private  String updHost;


	@ApiModelProperty(value = "用户职位")
	@Column(name = "position_id")
	private  Integer positionId;

	@ApiModelProperty(value = "用户来源:0-自来,1-用户邀请")
	@Column(name = "source")
	private  Integer source;


	@ApiModelProperty(value = "邀请码")
	@Column(name = "code")
	private  String code;

	@ApiModelProperty(value = "邀请人账号:")
	@Column(name = "inviter_account")
	private  Integer inviterAccount;
}
