package com.xxfc.platform.tour.rest.admin;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.tour.biz.TourGoodBiz;
import com.xxfc.platform.tour.biz.TourGoodDetailBiz;
import com.xxfc.platform.tour.dto.GoodSearchDTO;
import com.xxfc.platform.tour.dto.TourGoodDTO;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.vo.TourGoodDetailVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("good")
@IgnoreClientToken
public class TourGoodAdminController extends BaseController<TourGoodBiz, TourGood> {

    @Autowired
    TourGoodDetailBiz detailBiz;

    @ApiOperation("后台查询旅游路线列表")
    @RequestMapping(value = "/admin/goodList", method = RequestMethod.POST)
    public ObjectRestResponse<TourGood> goodList(@RequestBody GoodSearchDTO dto) {
        return ObjectRestResponse.succ(baseBiz.getAll(dto));
    }

    @ApiOperation("后台查询旅游更新")
    @RequestMapping(value = "/admin/goodEdit", method = RequestMethod.POST)
    public ObjectRestResponse<TourGood> goodEdit(@RequestBody TourGoodDTO dto) {
        return baseBiz.goodsEdit(dto);
    }

    @ApiOperation("后台查询旅游路线")
    @RequestMapping(value = "/admin/goodOne", method = RequestMethod.GET)
    public ObjectRestResponse<TourGoodDetailVo> goodEdit(@RequestParam(value = "id",defaultValue = "0")Integer id) {
        return detailBiz.findDetaileById(id);
    }

    @ApiOperation("后台旅游删除")
    @RequestMapping(value = "/admin/goodDel/{id}", method = RequestMethod.GET)
    public ObjectRestResponse goodDel(@PathVariable Integer id) {
        return baseBiz.delGoodById(id);
    }


    @ApiOperation("后台旅游上下架")
    @RequestMapping(value = "/admin/upStatus", method = RequestMethod.GET)
    public ObjectRestResponse upStatus(
            @RequestParam(value = "id",defaultValue = "0")Integer id,
            @RequestParam(value = "status",defaultValue = "1")Integer status) {
        return baseBiz.upStatusById(id,status);
    }


}