package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.uccn.biz.SearchBiz;
import com.xxfc.platform.uccn.comstnt.ServiceConstant;
import com.xxfc.platform.uccn.vo.SearchResultVo;
import com.xxfc.platform.vehicle.pojo.VehicleModelQueryCondition;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyFindDTO;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/17 9:47
 */
@RestController
@RequestMapping("/app/unauth/search")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Api(tags = "官网*综合搜索")
public class SearchController {

    private final SearchBiz searchBiz;

    private final VehicleModelController vehicleModelController;

    private final GwTourController gwTourController;

    private final CampsiteUccnController campsiteUccnController;

    private final ArticleController articleController;

    private final SummitActivityController summitActivityController;

    private final BranchCompanyController branchCompanyController;

    @GetMapping
    public ObjectRestResponse search(@RequestParam(value = "type", required = false,defaultValue = "") String type,
                                     @RequestParam(value = "keyword", required = false) String keyWord,
                                     @RequestParam(value = "page", required = false, defaultValue = "1") Integer page,
                                     @RequestParam(value = "limit", required = false, defaultValue = "10") Integer limit) {
        switch (type) {
            case ServiceConstant.VEHICLE:
                VehicleModelQueryCondition vehicleModelQueryCondition = new VehicleModelQueryCondition();
                vehicleModelQueryCondition.setPage(page);
                vehicleModelQueryCondition.setLimit(limit);
                vehicleModelQueryCondition.setVehicleName(keyWord);
                return vehicleModelController.findVehicleModelPageUnauthfind(vehicleModelQueryCondition);
            case ServiceConstant.BRANCH_COMPANY:
                BranchCompanyFindDTO branchCompanyFindDTO = new BranchCompanyFindDTO();
                branchCompanyFindDTO.setPage(page);
                branchCompanyFindDTO.setLimit(limit);
                branchCompanyFindDTO.setName(keyWord);
                return branchCompanyController.listBranchCompanyWithPage(branchCompanyFindDTO);
            case ServiceConstant.TROUR:
                return gwTourController.getGoodList(page, limit, null, keyWord);
            case ServiceConstant.CAMPSITE:
                return campsiteUccnController.findCampsiteShopPageByType(null, page, limit, keyWord);
            case ServiceConstant.NEWS:
                return articleController.getArticleList(page, limit, null, keyWord);
            case ServiceConstant.ACTIVITY:
                return summitActivityController.findSummitActivityWithPage(page, limit, null, keyWord);
            default:
                SearchResultVo searchResultVo = searchBiz.searchWithKeyWords(keyWord);
                return ObjectRestResponse.succ(searchResultVo);
        }
    }
}
