package com.xxfc.platform.universal.biz;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import lombok.AllArgsConstructor;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.UUID;

@Service
@AllArgsConstructor
public class MQServiceBiZ {

    private RabbitTemplate rabbitTemplate;

    @Transactional(rollbackFor = Exception.class)
    public ObjectRestResponse sendMessage(String exchange, String routKey, String json) {
        Message message = MessageBuilder.withBody(json.getBytes())
                .setContentType(MessageProperties.CONTENT_TYPE_JSON).setContentEncoding("utf-8")
                .setMessageId(UUID.randomUUID() + "").build();
        rabbitTemplate.convertAndSend(exchange, routKey, message);
        return ObjectRestResponse.succ();
    }
}
