package com.xxfc.platform.im.biz;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.dto.ImPraiseDto;
import com.xxfc.platform.im.dto.MsgTypeEnum;
import com.xxfc.platform.im.dto.UpdateTypeEnum;
import com.xxfc.platform.im.entity.ImPraise;
import com.xxfc.platform.im.entity.ImQuestion;
import com.xxfc.platform.im.mapper.ImPraiseMapper;
import lombok.extern.slf4j.Slf4j;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class ImPraiseBiz extends BaseBiz<ImPraiseMapper, ImPraise> {

    @Autowired
    ImQuestionBiz imQuestionBiz;

    @Autowired
    UserBiz userBiz;
    /**
     * 点赞
     * @param imPraiseDto
     * @return
     */
    public ObjectRestResponse add(ImPraiseDto imPraiseDto) {
        AppUserDTO appUserDTO = userBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        imPraiseDto.setUserId(Long.parseLong(appUserDTO.getImUserid() + ""));
        imPraiseDto.setNickname(appUserDTO.getNickname());
        imPraiseDto.setPicUrl(appUserDTO.getHeadimgurl());
        if(imPraiseDto == null || imPraiseDto.getQuestionId() == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        ImQuestion imQuestion = imQuestionBiz.selectById(imPraiseDto.getQuestionId());
        if(imQuestion == null) {
            return ObjectRestResponse.createDefaultFail();
        }
        List<ImPraise> list = getImPraiseList(imPraiseDto);
        if(list.size() >= 1) {
            return ObjectRestResponse.createFailedResult(504,"今日已点赞，请明日再点！");
        }
        insertSelective(imPraiseDto);
        imQuestionBiz.update(imPraiseDto.getQuestionId(), MsgTypeEnum.praise, UpdateTypeEnum.add);
        return ObjectRestResponse.succ();
    }

    /**
     * 取消点赞
     * @param imPraiseDto
     * @return
     */
    public ObjectRestResponse deleteById(ImPraiseDto imPraiseDto) {
        AppUserDTO appUserDTO = userBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        if(imPraiseDto == null || imPraiseDto.getQuestionId() == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        List<ImPraise> list = getImPraiseList(imPraiseDto);
        if(list.size() == 1) {
            list.get(0).setIsDel(true);
            updateSelectiveByIdRe(list.get(0));
            imQuestionBiz.update(list.get(0).getQuestionId(), MsgTypeEnum.praise, UpdateTypeEnum.subtraction);
        }
        return ObjectRestResponse.succ();
    }

    /**
     *  添加筛选当前天的点赞
     * @param imPraiseDto
     * @return
     */
    public List<ImPraise> getImPraiseList(ImPraiseDto imPraiseDto) {
        DateTime dateTime = new DateTime();
        Long startTime = dateTime.withTime(0,0,0,0).toDate().getTime();
        Long endTime = dateTime.plusDays(1).withTime(0,0,0,0).toDate().getTime();
        imPraiseDto.setStartTime(startTime);
        imPraiseDto.setEndTime(endTime);
        List<ImPraise> list = mapper.selectByQuestionIdAndTime(imPraiseDto);
        return list;
    }

}
