package com.xxfc.platform.activity.config;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitUserConfig {

    public static final String BASE_EXC = "hz_exchange";
    public static final String INTEGRAL_QUEUE = "integral_queue";
    public static final String ORDER_WATER_KEY = "order";

    /**
     * 队列交换机
     * 注意这里的交换机类型：CustomExchange
     * @return
     */
    @Bean
    public DirectExchange directExchange(){
        return new DirectExchange(BASE_EXC, true, false);
    }

    /**
     * 队列
     * @return
     */
    @Bean
    public Queue orderWaterQueue(){
        return new Queue(INTEGRAL_QUEUE,true);
    }

     /**
     * 队列绑定交换机
     * @return
     */
    @Bean
    public Binding orderWaterBinding(Queue orderWaterQueue, DirectExchange directExchange){
        return BindingBuilder.bind(orderWaterQueue).to(directExchange).with(ORDER_WATER_KEY);
    }

}

