package com.github.wxiaoqi.security.admin.handler;


import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.admin.biz.AppUserSellingWaterBiz;
import com.github.wxiaoqi.security.admin.config.RabbitAdminConfig;
import com.github.wxiaoqi.security.admin.dto.OrderWaterDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class IntegralMQHandler {

    @Autowired
    AppUserSellingWaterBiz waterBiz;
    @RabbitListener(queues = RabbitAdminConfig.ORDER_WATER_QUEUE)
    public void integralHandler(String json) {
        log.info("接收到的消息：json = {}", json);
        try{
            OrderWaterDTO orderWaterDTO = JSONObject.parseObject(json, OrderWaterDTO.class);
            waterBiz.orderWater(orderWaterDTO);
        }catch (Exception e){
            log.info("接收到的消息失败");
            e.printStackTrace();
        }

    }
}
