package com.github.wxiaoqi.security.admin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/18 9:50
 */
@Data
public class WalletDetailListDTO {

    private Integer id;

    private String username;

    private String nickname;

    private String realname;

    private String phone;

    @ApiModelProperty(value = "来源：0-活动，1-佣金，2-会员充值，10-提现，11-转账，12-购买")
    private Integer sourceType;

    @ApiModelProperty("活动名称或佣金商品名称")
    private String source;

    @ApiModelProperty(value = "收入/支出：0-收入，1-支出")
    private Integer itype;

    @ApiModelProperty(value = "收入/支出的金额(分)")
    private BigDecimal amount;


    @ApiModelProperty(value = "活动类型")
    private Integer type;


    @ApiModelProperty(value = "活动id")
    private Integer activityId;


    @ApiModelProperty("活动名称")
    private String activityName;


    @ApiModelProperty(value = "单号")
    private Integer cono;


    @ApiModelProperty(value = "加上当时的收入的余额")
    private BigDecimal balance;


    @ApiModelProperty(value = "操作时间", hidden = true )
    private Long crtTime;

}
