package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.BranchCompanyBiz;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.pojo.BranchCompanyVo;
import com.xxfc.platform.vehicle.pojo.CompanyDetail;
import com.xxfc.platform.vehicle.pojo.CompanySearchDTO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/branchCompany")
@Slf4j
@IgnoreClientToken
@IgnoreUserToken
@Api(value="公司controller",tags={"公司操作接口"})
public class BranchCompanyController extends BaseController<BranchCompanyBiz> {

    private static Integer MAX_DRIVING_LICENSE_SIZE  = 10*1024*1024;//10M

    @Autowired
    UserFeign userFeign;

    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @RequestMapping(value ="/page",method = RequestMethod.GET)
    public RestResponse<PageDataVO<BranchCompany>> page(@RequestParam Integer page, @RequestParam Integer limit,
                                                        @RequestParam(required = false) Integer addrProvince, @RequestParam(required = false) Integer addrCity,
                                                        @RequestParam(required = false) Integer addrTown, @RequestParam(required = false) String location) {
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        return RestResponse.data(baseBiz.getAll(page,limit,addrProvince,  addrCity, addrTown, userDTO));
    }

    @IgnoreUserToken
    @RequestMapping(value = "/allPage", method = RequestMethod.GET)
    public RestResponse<PageDataVO<BranchCompany>> allPage(@RequestParam Integer page, @RequestParam Integer limit,
                                                           @RequestParam(required = false) Integer addrProvince, @RequestParam(required = false) Integer addrCity,
                                                           @RequestParam(required = false) Integer addrTown) {
        return RestResponse.data(baseBiz.getAll(page,limit,addrProvince,  addrCity, addrTown, null));
    }

    @RequestMapping(value ="/search",method = RequestMethod.GET)
    @IgnoreUserToken
    @IgnoreClientToken
    public RestResponse<PageDataVO<BranchCompany>> search(@Validated CompanySearchDTO vo) {
        return RestResponse.data(baseBiz.search(vo));
    }

    @RequestMapping(value ="",method = RequestMethod.GET)
    public RestResponse<List<BranchCompany>> getAll() {
        return RestResponse.data(baseBiz.getAll());
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.GET)
    public RestResponse<BranchCompany> get(@PathVariable Integer id) {
        return RestResponse.data(baseBiz.getById(id));
    }

    @ApiOperation("获取公司详情")
    @RequestMapping(value ="/app/unauth/detail/{id}",method = RequestMethod.GET)
    public ObjectRestResponse<CompanyDetail> getDetail(@PathVariable Integer id) {
        return ObjectRestResponse.succ(baseBiz.getDetailById(id));
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    public RestResponse<Integer> add(@RequestBody BranchCompanyVo branchCompanyVo) {
        return RestResponse.data(baseBiz.add(branchCompanyVo));
    }

    @RequestMapping(value ="/upload/companyPic",method = RequestMethod.POST)
    public RestResponse uploadCompanyPic(@RequestParam("file") MultipartFile file)
            throws Exception{
        String contentType = file.getContentType();   //图片文件类型
//        String fileName = file.getOriginalFilename();  //图片名字
        if(!contentType.equals("image/jpeg") && !contentType.equals("image/gif")){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        if(file.getSize() > MAX_DRIVING_LICENSE_SIZE){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return baseBiz.uploadCompanyPic(file);
    }

    @RequestMapping(value ="",method = RequestMethod.PUT)
    public RestResponse update(@RequestBody BranchCompany branchCompany) {
        baseBiz.update(branchCompany);
        return RestResponse.sucResponse();
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.DELETE)
    public RestResponse del(@PathVariable Integer id) {
        baseBiz.del(id);
        return RestResponse.sucResponse();
    }

    /**
     * 导入
     * @param multipartfile
     * @param request
     * @return
     */
    @PostMapping("importExcel")
    public RestResponse importExcel(@RequestParam(value = "file") MultipartFile multipartfile,
                                    HttpServletRequest request) {
        return baseBiz.importExcel(multipartfile,request);
    }
    //获取分公司列表
    @GetMapping("list")
    public  RestResponse<List<BranchCompany>>  companyList() {
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        return RestResponse.data(baseBiz.getListByUser(userDTO));
    }
    //获取分公司列表
    @GetMapping("all")
    public  List<BranchCompany>  companyAll(
            @RequestParam(value = "dataAll",defaultValue = "2")Integer dataAll,
            @RequestParam(value = "dataCompany",defaultValue = "")String dataCompany,
            @RequestParam(value = "dataZone",defaultValue = "")String dataZone
    ) {
        UserDTO userDTO=new UserDTO();
        userDTO.setDataAll(dataAll);
        if(StringUtils.isNotBlank(dataCompany)){
            userDTO.setDataCompany(dataCompany);
        }
        if(StringUtils.isNotBlank(dataZone)){
            userDTO.setDataZone(dataZone);
        }
        return baseBiz.getListByUser(userDTO);
    }
}
