package com.xxfc.platform.order.biz;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.IntervalUtil;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.google.common.collect.Lists;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.contant.enumerate.RefundStatusEnum;
import com.xxfc.platform.order.contant.enumerate.RefundTypeEnum;
import com.xxfc.platform.order.entity.*;
import com.xxfc.platform.order.mapper.BaseOrderMapper;
import com.xxfc.platform.order.pojo.order.OrderListVo;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.order.pojo.order.OrderVehicleCrosstownDto;
import com.xxfc.platform.tour.feign.TourFeign;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.universal.vo.OrderRefundVo;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;
import static com.xxfc.platform.universal.constant.DictionaryKey.*;

/**
 * 
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-15 21:30:33
 */
@Service
@Slf4j
public class BaseOrderBiz extends BaseBiz<BaseOrderMapper,BaseOrder> {

    @Autowired
    OrderMemberDetailBiz orderMemberDetailBiz;

    @Autowired
    OrderTourDetailBiz orderTourDetailBiz;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderVehicalCrosstownBiz orderVehicalCrosstownBiz;

    @Autowired
    OrderUserLicenseBiz orderUserLicenseBiz;

    @Autowired
    OrderRefundBiz orderRefundBiz;

    @Autowired
    VehicleFeign vehicleFeign;

    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    TourFeign tourFeign;

    @Autowired
    UserFeign userFeign;

    public List<OrderPageVO> pageByParm(Map<String, Object> paramMap){
        return mapper.pageByParm(paramMap);
    }

    public List<OrderListVo> listOrder(Map<String, Object> paramMap){

        return mapper.listOrder(paramMap);
    }
    public List<OrderPageVO> getRentVehicle (Map<String, Object> paramMap) {
        return mapper.getRentVehicle(paramMap);
    }
    public List<OrderPageVO> getTourList (Map<String, Object> paramMap) {
        return mapper.getTourList(paramMap);
    }
    private static Map<Integer, List<Integer>> cancelAble;
    static {
        cancelAble = new HashMap<Integer, List<Integer>>();
        cancelAble.put(OrderTypeEnum.RentVehicle.getCode(), new LinkedList<Integer>(){{
            add(OrderStatusEnum.ORDER_UNPAY.getCode());
            add(OrderStatusEnum.ORDER_TOSTART.getCode());
        }});
        cancelAble.put(OrderTypeEnum.TOUR.getCode(), new LinkedList<Integer>(){{
            add(OrderStatusEnum.ORDER_UNPAY.getCode());
            add(OrderStatusEnum.ORDER_TOSTART.getCode());
        }});
        cancelAble.put(OrderTypeEnum.MEMBER.getCode(), new LinkedList<Integer>(){{
            add(OrderStatusEnum.ORDER_UNPAY.getCode());
        }});
    }

    /**
     * 获取订单详情
     * @param no
     * @return
     */
    public ObjectRestResponse getOrderDetail(String no) {
        OrderPageVO orderPageVo = mapper.getOrderDetail(no);
        if(orderPageVo == null) {
            return ObjectRestResponse.createDefaultFail();
        }

        if(orderPageVo.getStatus() == 4) { //未交车
           List<VehicleUserLicense> vehicleUserLicenses = Lists.newArrayList();
           String myDriverIds = orderPageVo.getOrderRentVehicleDetail().getMyDriverIds();
           if(StringUtils.isNotBlank(myDriverIds)) {
               if(myDriverIds.contains(",")) {
                   String[] ids = myDriverIds.split(",");
                   try{
                       //目前暂定一个驾驶人，后期需要更改再此更改
                       RestResponse<VehicleUserLicense> restResponse = vehicleFeign.getOne(Integer.parseInt(ids[0]));
                       log.info(restResponse.getMessage());
                       if(restResponse.getData() != null) {
                           vehicleUserLicenses.add(restResponse.getData());
                       }
                   }catch (Exception e) {
                       e.printStackTrace();
                   }
               } else {
                   try {
                       vehicleUserLicenses.add(vehicleFeign.getOne(Integer.parseInt(myDriverIds.trim())).getData());
                   }catch (Exception e){
                       e.printStackTrace();
                   }
               }
           }
           orderPageVo.setVehicleUserLicenses(vehicleUserLicenses);
       } else if(orderPageVo.getStatus() >= 5) {//出行中 已交车
            OrderVehicleCrosstownDto orderVehicleCrosstownDto = new OrderVehicleCrosstownDto();
            orderVehicleCrosstownDto.setOrderId(orderPageVo.getId());
            orderVehicleCrosstownDto.setOrderNo(orderPageVo.getNo());
            List<OrderVehicaleCrosstown> orderVehicaleCrosstowns = orderVehicalCrosstownBiz.selectByOrderId(orderVehicleCrosstownDto);
            if(orderVehicaleCrosstowns != null && orderVehicaleCrosstowns.size() > 0) {
                List<OrderUserLicense> orderUserLicenses = orderUserLicenseBiz.selectByIds(orderVehicaleCrosstowns.get(0).getUserLicenseId()).getData();
                if(orderUserLicenses != null && orderUserLicenses.size() > 0) {
                    orderVehicleCrosstownDto.setLicenseIdCard(orderUserLicenses.get(0).getLicenseIdCard());
                    orderVehicleCrosstownDto.setLicenseImg(orderUserLicenses.get(0).getLicenseImg());
                    orderVehicleCrosstownDto.setLicenseName(orderUserLicenses.get(0).getLicenseName());
                    orderVehicleCrosstownDto.setLicensePhone(orderUserLicenses.get(0).getLicensePhone());
                }

            }
            orderPageVo.setOrderVehicleCrosstownDto(orderVehicleCrosstownDto);
        }

        return ObjectRestResponse.succ(orderPageVo);
    }

    /**
     * 取消订单
     * @param baseOrder
     */
    @Transactional
    public void cancel(BaseOrder baseOrder) {
        if(cancelAble.get(baseOrder.getType()).contains(baseOrder.getStatus())) {
            BaseOrder updateOrder = new BaseOrder(){{
                setId(baseOrder.getId());
                setStatus(OrderStatusEnum.ORDER_CANCEL.getCode());
                setCancelReason(baseOrder.getCancelReason());
                setVersion(baseOrder.getVersion());
            }};
            BaseOrder hasUpdateOrder = this.updateSelectiveByIdReT(updateOrder);

            //触发退款流程
                //判断是否已支付
            if(SYS_TRUE.equals(baseOrder.getHasPay())) {
                //判断订单类型
                if(OrderTypeEnum.RentVehicle.getCode().equals(baseOrder.getType())) {
                    OrderRentVehicleDetail orvd = orderRentVehicleBiz.selectOne(new OrderRentVehicleDetail(){{
                        setOrderId(baseOrder.getId());
                    }});

                    //退款流程
                    rentRefundProcess(hasUpdateOrder, orvd.getDeposit(), orvd.getStartTime(), APP_ORDER+ "_"+ RENT_REFUND);

                }else if (OrderTypeEnum.TOUR.getCode().equals(baseOrder.getType())) {
                    OrderTourDetail otd = orderTourDetailBiz.selectOne(new OrderTourDetail(){{
                        setOrderId(baseOrder.getId());
                    }});
                        //退款流程
                    rentRefundProcess(hasUpdateOrder, otd.getStartTime(), APP_ORDER+ "_"+ TOUR_REFUND);
                }
            }

            //处理取消流程
            if(OrderTypeEnum.RentVehicle.getCode().equals(baseOrder.getType())) {
                OrderRentVehicleDetail orvd = orderRentVehicleBiz.selectOne(new OrderRentVehicleDetail(){{
                    setOrderId(baseOrder.getId());
                }});

                //取消租车预定
                    //已支付,并且是待出行状态，取消预约
                if(OrderStatusEnum.ORDER_TOSTART.equals(baseOrder.getType()) && SYS_TRUE.equals(baseOrder.getHasPay())){
                    vehicleFeign.unbookVehicle(orvd.getBookRecordId());
                }else {
                    //未支付，拒绝之前的预约
                    RestResponse<Integer> restResponse = vehicleFeign.rentRejectVehicleBooking(orvd.getBookRecordId());
                }

                //取消租车免费天数使用
                if(null != orvd.getFreeDays() && orvd.getFreeDays() > 0) {
                    int result = userFeign.memberDays(baseOrder.getUserId(), orvd.getFreeDays(), UserFeign.MEMBER_DAYS_WITHDRAW);
                    if(result < 0) {
                        throw new BaseException(ResultCode.FAILED_CODE);
                    }
                }
                
            }else if(OrderTypeEnum.TOUR.getCode().equals(baseOrder.getType())) {
                OrderTourDetail otd = orderTourDetailBiz.selectOne(new OrderTourDetail(){{
                    setOrderId(baseOrder.getId());
                }});

                //增加库存
                tourFeign.stock(otd.getSpePriceId(), otd.getTotalNumber(), TourFeign.STOCK_PLUS);
            }
        }else {
            throw new BaseException(ResultCode.FAILED_CODE);
        }
    }

    /**
     * 租车退款流程(不含押金的通用方法)
     * @param baseOrder
     * @param startTime
     * @param dicParentKey
     */
    private void rentRefundProcess(BaseOrder baseOrder, Long startTime, String dicParentKey){
        rentRefundProcess(baseOrder, BigDecimal.ZERO, startTime, dicParentKey);
    }

    /**
     * 租车退款流程(含押金)
     * @param baseOrder
     * @param depositAmont
     * @param startTime
     * @param dicParentKey
     */
    private void rentRefundProcess(BaseOrder baseOrder, BigDecimal depositAmont, Long startTime, String dicParentKey) {
        //计算退款金额
        // 1、押金 + 租金(规则扣除)
        BigDecimal refundGoodsAmount = baseOrder.getGoodsAmount();
        String refundDesc = "取消订单退款:";
        BigDecimal refundGoodsAmont = baseOrder.getGoodsAmount();
        if(null == depositAmont) {
            depositAmont = BigDecimal.ZERO;
        }

        //根据时间处理goodsAmount
            //获取出发时间 到现在 距离时间
        Long timeLag = startTime - System.currentTimeMillis();
        Integer hourLag = Long.valueOf(timeLag/(1000L * 60L * 60L)).intValue();

        Map<String, com.xxfc.platform.universal.entity.Dictionary> dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
        Set<com.xxfc.platform.universal.entity.Dictionary> rentRefunds = dictionaryMap.get(dicParentKey).getChildrens();

        for(com.xxfc.platform.universal.entity.Dictionary dic : rentRefunds) {
            if(StrUtil.isBlank(dic.getName())) {
                continue;
            }
            String[] names = dic.getName().split("\\|");
            if(names.length < 2) {
                continue;
            }

            //符合范围
            if(IntervalUtil.staticIsInTheInterval(hourLag.toString(), names[0])){
                refundGoodsAmont = new BigDecimal((IntervalUtil.evaluate(dic.getDetail(), new MapContext(){{
                    //ga : goodsAmount
                    set("ga", baseOrder.getGoodsAmount());
                }})).toString());
                refundDesc = names[1]+ ","+ refundDesc;
                break;
            }
        }

        //退款金额
        BigDecimal refundAmont = depositAmont.add(refundGoodsAmont);
        //退款子流程: 订单基础，退款描述，退款金额
        refundSubProcess(baseOrder, refundDesc, refundAmont, RefundTypeEnum.RentVehicle.getCode(), RefundStatusEnum.ALL.getCode());
    }

    /**
     * 退款子流程
     * @param baseOrder
     * @param refundDesc
     * @param refundAmont
     * @param refundType
     * @param refundStatus
     */
    public void refundSubProcess(BaseOrder baseOrder, String refundDesc, BigDecimal refundAmont, Integer refundType, Integer refundStatus) {
        OrderRefundVo orv = new OrderRefundVo(){{
            setAmount(baseOrder.getRealAmount().multiply(new BigDecimal("100")).intValue());
            setOrderNo(baseOrder.getNo());
        }};
        orv.setRefundDesc(refundDesc+ refundAmont.toString());
        orv.setRefundAmount(refundAmont.multiply(new BigDecimal("100")).intValue());
        String refundTradeNo = thirdFeign.refund(orv).getData();

        //记录订单退款记录
        Integer flag = addOrderRefund(baseOrder.getId(), refundDesc, refundAmont, refundTradeNo, refundType);

        //更新订单的退款状态和退款时间
        if(SYS_TRUE.equals(flag) && null != refundStatus) {
            updateSelectiveByIdReT(new BaseOrder(){{
                setId(baseOrder.getId());
                setRefundStatus(refundStatus);
                setRefundTime(System.currentTimeMillis());
                setVersion(baseOrder.getVersion());
            }});
        }
    }

    /**
     * 记录订单退款记录
     * @param orderId
     * @param refundDesc
     * @param refundAmont
     * @param refundTradeNo
     */
    private Integer addOrderRefund(Integer orderId, String refundDesc, BigDecimal refundAmont, String refundTradeNo, Integer refundType) {
        //如果返回的流水为空，则当做失败
        Integer refundStatus = SYS_TRUE;
        if(StrUtil.isBlank(refundTradeNo)) {
            refundStatus = SYS_FALSE;
        }

        //创建订单退款记录
        OrderRefund orderRefund = new OrderRefund(){{
            setOrderId(orderId);
            setRefundTime(System.currentTimeMillis());
            setTradeNo(refundTradeNo);
            setRefundType(RefundTypeEnum.RentVehicle.getCode());
        }};
        orderRefund.setRefundAmount(refundAmont);
        orderRefund.setRefundDesc(refundDesc);
        orderRefund.setRefundStatus(refundStatus);
        orderRefund.setRefundType(refundType);
        orderRefundBiz.insertSelective(orderRefund);

        return refundStatus;
    }

    /**
     * 支付回调处理
     * @param orderNo
     * @param tradeNo
     */
    public void payNotifyHandle(String orderNo, String tradeNo, Integer type) {
        BaseOrder baseOrder = this.selectOne(new BaseOrder() {{
            setNo(orderNo);
        }});

        if (OrderStatusEnum.ORDER_UNPAY.getCode().equals(baseOrder.getStatus()) && baseOrder.getHasPay().equals(SYS_FALSE)) {
            BaseOrder updateOrder = new BaseOrder() {{
                setId(baseOrder.getId());
                setOutTradeNo(tradeNo);
                setHasPay(SYS_TRUE);
                setPayTime(System.currentTimeMillis());
                setPayOrigin(type);
                setVersion(baseOrder.getVersion());
            }};

            //如果是会员订单，则触发会员效益
            if(OrderTypeEnum.MEMBER.getCode().equals(baseOrder.getType())) {
                //直接设置订单完成
                updateOrder.setStatus(OrderStatusEnum.ORDER_FINISH.getCode());
                OrderMemberDetail omd = orderMemberDetailBiz.selectOne(new OrderMemberDetail(){{
                    setOrderId(baseOrder.getId());
                }});

                //触发会员效益
                ObjectRestResponse orr = userFeign.buyMember(new UserMemberDTO() {{
                    setUserId(baseOrder.getUserId());
                    setDiscount(omd.getRebate());
                    setIsBind(ISBIND_BIND);
                    setMemberLevel(omd.getMemberLevel());
                    setRentFreeDays(omd.getRentFreeNum());
                    setTotalNumber(omd.getRentFreeNum());
                }});
                log.info("orr.getStatus() : " + orr.getStatus() );
            }else if(OrderTypeEnum.RentVehicle.getCode().equals(baseOrder.getType())) {
                updateOrder.setStatus(OrderStatusEnum.ORDER_TOSTART.getCode());
                OrderRentVehicleDetail orvd = orderRentVehicleBiz.selectOne(new OrderRentVehicleDetail(){{
                    setOrderId(baseOrder.getId());
                }});
                //车辆预定审核通过

                //确认免费天数
                if(orvd.getFreeDays() > 0) {
                    userFeign.memberDays(baseOrder.getUserId(), orvd.getFreeDays(), UserFeign.MEMBER_DAYS_CONFIRM);
                }

            }else if(OrderTypeEnum.TOUR.getCode().equals(baseOrder.getType())) {
                updateOrder.setStatus(OrderStatusEnum.ORDER_TOSTART.getCode());
                OrderTourDetail otd = orderTourDetailBiz.selectOne(new OrderTourDetail(){{
                    setOrderId(baseOrder.getId());
                }});

                //站点总人数添加
                 tourFeign.updateTourGoodPersonNum(otd.getVerificationId(), TourFeign.TOTAL_PERSON, otd.getTotalNumber());
            }
            this.updateSelectiveByIdRe(updateOrder);
        } else {
            log.error(" order has payed , orderNo:{}, tradeNo:{} ", orderNo, tradeNo);
        }
    }

    public BaseOrder updateSelectiveByIdReT(BaseOrder baseOrder) {
        if(updateSelectiveByIdRe(baseOrder) > 0) {
            return selectById(baseOrder.getId());
        }else {
            throw new BaseException(ResultCode.DB_OPERATION_FAIL_CODE);
        }
    }
}