package com.github.wxiaoqi.security.auth.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.api.vo.user.UserInfo;
import com.github.wxiaoqi.security.auth.common.util.jwt.JWTInfo;
import com.github.wxiaoqi.security.auth.feign.IUserService;
import com.github.wxiaoqi.security.auth.service.AuthService;
import com.github.wxiaoqi.security.auth.util.user.JwtAuthenticationRequest;
import com.github.wxiaoqi.security.auth.util.user.JwtTokenUtil;
import com.github.wxiaoqi.security.common.constant.RequestTypeConstants;
import com.github.wxiaoqi.security.common.exception.auth.UserInvalidException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service("baseAuthService")
public class AuthServiceImpl implements AuthService {

    private JwtTokenUtil jwtTokenUtil;
    private IUserService userService;

    @Autowired
    public AuthServiceImpl(
            JwtTokenUtil jwtTokenUtil,
            IUserService userService) {
        this.jwtTokenUtil = jwtTokenUtil;
        this.userService = userService;
    }

    @Override
    public String login(JwtAuthenticationRequest authenticationRequest) throws Exception {
        UserInfo info = userService.validate(authenticationRequest);
        if (!StringUtils.isEmpty(info.getId())) {
            return jwtTokenUtil.generateToken(new JWTInfo(info.getUsername(), info.getId() + "", info.getName()));
        }
        throw new UserInvalidException("用户不存在或账户密码错误!");
    }

    @Override
    public void validate(String token) throws Exception {
        jwtTokenUtil.getInfoFromToken(token);
    }

    @Override
    public String refresh(String oldToken) throws Exception {
        return jwtTokenUtil.generateToken(jwtTokenUtil.getInfoFromToken(oldToken));
    }
    @Override
    public JSONObject sendsms(String username, Integer type) throws Exception {
        return userService.sendsms(username,type);
    }
    @Override
    public JSONObject register(String username, String mobilecode, String password) throws Exception {
        return userService.register(username,mobilecode,password);
    }

    @Override
    public JSONObject wxregister(String username, String mobilecode, String password, String nickname, String headimgurl, String openid, String unionid, Integer type,Integer  isQQ) throws Exception {
        return userService.wxregister(username,mobilecode,password,nickname,headimgurl,openid,unionid,type,isQQ);
    }

    @Override
    public JSONObject checkBindWechat(String username) throws Exception {
        return userService.checkBindWechat(username);
    }

    @Override
    public JSONObject wxlogin(String openid,Integer isQQ) throws Exception {
        return userService.wxlogin(openid,isQQ);
    }

    @Override
    public JSONObject tlogin(String username, String password, String mobilecode, Integer type) throws Exception {
        return userService.login(username,password,mobilecode,type);
    }

    @Override
    public String getToken(String username,Integer id) throws Exception {
        return jwtTokenUtil.generateToken(new JWTInfo(username, id + "",null,
                RequestTypeConstants.APP));
    }
    @Override
    public JSONObject reset(String username, String mobilecode, String password) throws Exception {
        return userService.reset(username,mobilecode,password);
    }

    @Override
    public JSONObject appletLoginByUserId(Integer userid) {
        return userService.appletLogin(userid);
    }

    @Override
    public JSONObject appletRegistry(String username,String headimgurl,String nickname,Integer  userid) {
        return userService.appletRegistry(username,headimgurl,nickname,userid);
    }
}
