package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.biz.VehicleDepartureService;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.VehicleDepartureLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@IgnoreClientToken
@RestController
@RequestMapping("departure")
public class VehicleDepartureController {

    @Autowired
    VehicleDepartureService vehicleDepartureService;
    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    UserFeign userFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @GetMapping("page")
    public RestResponse page(String numberPlate, Integer page, Integer limit, HttpServletRequest request) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        if (userDTO != null) {
            if (userDTO.getDataAll() == 2) {
                List<Integer> companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
                return RestResponse.data(vehicleDepartureService.pageNotAllData(numberPlate, page, limit, companyList));
            }
        }
        return RestResponse.suc(vehicleDepartureService.page(numberPlate, page, limit));
    }

    @GetMapping("findByVehicle")
    public RestResponse findByVehicle(String vehicleId, Integer page, Integer limit) {
        if (vehicleId == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(vehicleDepartureService.findByVehicle(vehicleId, page, limit));
    }

    @GetMapping("statistic")
    public RestResponse statistic(String numberPlate) {
        if (numberPlate == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(vehicleDepartureService.statistic(numberPlate));
    }

    /**
     * 保存(出车)
     * @param vehicleDepartureLog
     * @return
     */
    @PostMapping("/app/save")
    public ObjectRestResponse save(@RequestBody VehicleDepartureLog vehicleDepartureLog){
        return vehicleDepartureService.save(vehicleDepartureLog);
    }

    /**
     * 查询一条
     * @param vid 车辆id
     * @return
     * @throws Exception
     */
    @GetMapping("/app/findOne/{id}")
    public  ObjectRestResponse findOne(@PathVariable Integer vid) throws Exception {
       return vehicleDepartureService.findOne(vid);
    }

    /**
     *
     * 收车
     * @param vdl
     * @return
     * @throws Exception
     */
    @PutMapping("/app/collect")
    public  ObjectRestResponse collect(@RequestBody VehicleDepartureLog vdl) throws Exception {
        return vehicleDepartureService.collect(vdl);
    }


}
