package com.xxfc.platform.campsite.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;


/**
 * 店铺轮播表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@Table(name = "campsite_shop_carousel")
@ApiModel(value = "店铺轮播Vo")
public class CampsiteShopCarouselDTO implements Serializable {
    private static final long serialVersionUID = 1L;


    private Integer id;

    /**
     * 商家id
     */
    @ApiModelProperty(value = "商家id")
    private Integer shopId;

    /**
     * 访问链接
     */
    @ApiModelProperty(value = "访问链接")
    private String url;

    /**
     * 轮播图片链接
     */
    @ApiModelProperty(value = "轮播图片链接")
    private String imgUrl;

    /**
     * 图片名称
     */
    @ApiModelProperty(value = "图片名称")
    private String name;

    /**
     * 是否删除：0-正常；1-删除
     */
    @ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;


}
