package com.xxfc.platform.vehicle.aop;


import com.github.wxiaoqi.security.common.util.HttpContextUtils;
import com.github.wxiaoqi.security.common.util.IPUtils;
import com.xxfc.platform.vehicle.biz.SysLogBiz;
import com.xxfc.platform.vehicle.entity.SysLog;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleApply;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;

@Aspect
@Component
public class LogAspect {


    @Autowired
    SysLogBiz sysLogBiz;


    @Pointcut("@annotation(com.xxfc.platform.vehicle.aop.GlobalLog)")
    public void pointcut() { }

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint point) {
        Object result = null;
        long beginTime = System.currentTimeMillis();
        try {
            // 执行方法
            result = point.proceed();
            // 执行时长(毫秒)
            long time = System.currentTimeMillis() - beginTime;
            // 保存日志
            saveLog(point, time);
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    private void saveLog(ProceedingJoinPoint joinPoint, long time) {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        Method method = signature.getMethod();
        SysLog sysLog = new SysLog();
        GlobalLog logAnnotation = method.getAnnotation(GlobalLog.class);
        if (logAnnotation != null) {
            // 注解上的描述
            sysLog.setOperation(logAnnotation.value());
            sysLog.setType(logAnnotation.type());
        }
        // 请求的方法名
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        sysLog.setMethod(className + "." + methodName + "()");
        // 请求的方法参数值
        Object[] args = joinPoint.getArgs();
        // 请求的方法参数名称
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] paramNames = u.getParameterNames(method);

        if (args != null && paramNames != null) {
            String vehicleId = null;
            String params = "";
            Integer state = 0;
            for (int i = 0; i < args.length; i++) {
                params += "  " + paramNames[i] + ": " + args[i];
                if (paramNames[i].equals("vehicle")){
                    Vehicle vehicle = (Vehicle)args[i];
                    vehicleId = vehicle.getId();
                    state = vehicle.getState();
                }else if (paramNames[i].equals("vehicleApply")){
                    VehicleApply vehicleApply = (VehicleApply)args[i];
                    vehicleId = vehicleApply.getVehicleId();
                    state = vehicleApply.getApplyStatus() == 1 ? 1 : 0;
                }
            }
            if (state > 0){
                return;
            }
            sysLog.setParams(params);
            sysLog.setVehicleId(vehicleId);
            sysLog.setOperateType(state);
        }
        // 获取request
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        // 设置IP地址
        sysLog.setIp(IPUtils.getIpAddr(request));

        sysLog.setTime(time);
        // 保存系统日志
        sysLogBiz.addLog(sysLog);
    }
}
