package com.xxfc.platform.vehicle.pojo.vo;


import com.xxfc.platform.vehicle.entity.VehiclePublishReceive;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class VehiclePublishReceiveVo extends VehiclePublishReceive {


    @ApiModelProperty("品牌名称")
    String brandName;


    @ApiModelProperty("型号名称")
    String categoryName;


    @ApiModelProperty("车牌号")
    String numberPlate;

    @ApiModelProperty("数量")
    Long number;

    @ApiModelProperty("待确认数量")
    Long waitNumber;

    @ApiModelProperty("按钮状态：1-确认;2-收车；3-完成")
    private  Integer buttonState;


    @ApiModelProperty("用户名")
    String userName;


    private List<VehicleExtensionVO> extensionVOS;


    @ApiModelProperty("接单公司")
    String receiveCompanyName;


    @ApiModelProperty("发布公司")
    String publishCompanyName;


    @ApiModelProperty("需求id")
    private  Integer publishId;


    @ApiModelProperty("接单者服务费（单个商品）")
    private BigDecimal receiveAmount;

    @ApiModelProperty("发布服务费（单个商品）")
    private BigDecimal publishAmount;

    @ApiModelProperty("状态str")
    private  String statusStr;

    @ApiModelProperty("接单ids")
    private String ids;


    @ApiModelProperty("编号")
    String code;

    private List<VehiclePublishReceiveVo>  publishReceiveVos;


}
