package com.xxfc.platform.im.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.biz.ImPraiseBiz;
import com.xxfc.platform.im.dto.ImPraiseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "imPraise")
@Api(value = "点赞")
public class ImPraiseController {

    @Autowired
    ImPraiseBiz imPraiseBiz;

    @PostMapping(value = "/add")
    @ApiOperation(value = "添加点赞")
    public ObjectRestResponse add( ImPraiseDto imPraise) {
        return imPraiseBiz.add(imPraise);
    }

    @PostMapping(value = "/delete")
    @ApiOperation(value = "取消点赞")
    public ObjectRestResponse deleteById(ImPraiseDto imPraiseDto) {
        return imPraiseBiz.deleteById(imPraiseDto);
    }

}
