package com.xxfc.platform.im.feign;


import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.dto.AppUserV2DTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-im")
public interface ImFeign {

    /**
     * 注册
     * @param map
     * @return
     */
    @RequestMapping(value = "/user/app/unauth/register", method = RequestMethod.POST)
    public BaseResponse register(@RequestBody Map<String,Object> map);

    /**
     * 登录
     * @param map
     * @return
     */
    @RequestMapping(value = "/user/app/unauth/login", method = RequestMethod.POST)
    public BaseResponse login(@RequestBody Map<String,Object> map);


    @PostMapping(value = "user/updateV2")
    ObjectRestResponse updateV2(@RequestBody AppUserV2DTO appUserV2DTO);

}
