package com.github.wxiaoqi.security.admin.biz;


import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.dto.UserCommentFindDTO;
import com.github.wxiaoqi.security.admin.entity.*;
import com.github.wxiaoqi.security.admin.mapper.UserCommentMapper;
import com.github.wxiaoqi.security.admin.vo.UserCommentVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.feign.OrderFeign;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Comparator;
import java.util.Date;
import java.util.List;


@Service
@Slf4j
public class UserCommentBiz extends BaseBiz<UserCommentMapper, UserComment>{
    @Autowired
    private OrderFeign orderFeign;







    public void addOrUpd(UserComment userComment){
        if (StringUtils.isBlank(userComment.getCommentText())){
            throw  new BaseException("参数不能为空", ResultCode.FAILED_CODE);
        }
        Integer parentId = userComment.getParentId() == null ? 0 : userComment.getParentId();
        Integer rootParentId = userComment.getRootParentId() == null ? 0 : userComment.getRootParentId();
        if (parentId > 0){
            UserComment parentComment = selectById(parentId);
            if (parentComment == null ){
                throw  new BaseException("该评论不存在", ResultCode.FAILED_CODE);
            }
            rootParentId=parentComment.getRootParentId();
            userComment.setSoureId(parentComment.getSoureId());
            userComment.setSoureUserId(parentComment.getSoureUserId());
            userComment.setSoureType(parentComment.getSoureType());
            userComment.setToUserId(parentComment.getUserId());
            userComment.setRootParentId(rootParentId);
        }else {
            if (StringUtils.isBlank(userComment.getSoureId())){
                throw  new BaseException("资源ID不能为空", ResultCode.FAILED_CODE);
            }
        }
        userComment.setCreateTime(new Date());
        insertSelective(userComment);
        Integer id = userComment.getId();
        if (id > 0 ){
            if (rootParentId == 0){
                UserComment userComment1=new UserComment();
                userComment1.setId(id);
                userComment1.setRootParentId(id);
                updateSelectiveById(userComment1);
            }else {
                mapper.addreplyNum(rootParentId);
            }
        }
    }


    public PageDataVO<UserCommentVo> selectList(UserCommentFindDTO userCommentFindDTO){
        PageHelper.startPage(userCommentFindDTO.getPage(), userCommentFindDTO.getLimit());
        PageInfo<UserCommentVo> pageInfo = new PageInfo<>(getList(userCommentFindDTO));
        PageDataVO<UserCommentVo> dataVO = PageDataVO.pageInfo(pageInfo);
        Integer rootParentId = userCommentFindDTO.getRootParentId() == null ? 0 : userCommentFindDTO.getRootParentId();
        if (rootParentId == 0 && dataVO.getData() != null){
            List<UserCommentVo> list = dataVO.getData();
            if (list != null && list.size() > 0){
                for (UserCommentVo commentVo:list){
                    userCommentFindDTO.setParentId(null);
                    userCommentFindDTO.setRootParentId(commentVo.getRootParentId());
                    PageDataVO<UserCommentVo> pageDataVO=selectList(userCommentFindDTO);
                    if (pageDataVO != null ){
                        commentVo.setChilder(pageDataVO);
                    }
                }
            }
        }
        return dataVO;
    }


    public  List<UserCommentVo> getList(UserCommentFindDTO commentFindDTO){
        return  mapper.selectList(commentFindDTO);
    }


    public PageDataVO<UserCommentVo> selectListByToUserId(UserCommentFindDTO userCommentFindDTO){
        PageHelper.startPage(userCommentFindDTO.getPage(), userCommentFindDTO.getLimit());
        PageInfo<UserCommentVo> pageInfo = new PageInfo<>(getListByToUserId(userCommentFindDTO));
        PageDataVO<UserCommentVo> dataVO = PageDataVO.pageInfo(pageInfo);
        return dataVO;
    }


    public void setParamByVehicle(UserCommentFindDTO userCommentFindDTO){
            UserComment comment = selectById(userCommentFindDTO.getCommentId());
            if (comment != null ){
                userCommentFindDTO.setSoureId(comment.getSoureId());
                userCommentFindDTO.setIsShow(1);
                userCommentFindDTO.setIsDesc(1);
                userCommentFindDTO.setUserId(comment.getUserId());
            }

    }



    public  List<UserCommentVo> getListByToUserId(UserCommentFindDTO commentFindDTO){
        return  mapper.selectListByToUserId(commentFindDTO);
    }


    public PageDataVO<UserCommentVo> selectListV2(UserCommentFindDTO userCommentFindDTO){
        PageHelper.startPage(userCommentFindDTO.getPage(), userCommentFindDTO.getLimit());
        Integer commentId = userCommentFindDTO.getCommentId() == null ? 0 : userCommentFindDTO.getCommentId();
        if (commentId > 0){
            setParamByVehicle(userCommentFindDTO);
        }
        PageInfo<UserCommentVo> pageInfo = new PageInfo<>(getList(userCommentFindDTO));
        PageDataVO<UserCommentVo> dataVO = PageDataVO.pageInfo(pageInfo);
        List<UserCommentVo> list = dataVO.getData();
        if (CollectionUtils.isNotEmpty(list)){
            list.sort(Comparator.comparing(UserCommentVo::getId));
            dataVO.setData(list);
        }
        return dataVO;
    }

    /**
     * 订单评论
     * 处理维度
     * 总分
     * @param userComment
     */
    public void saveComment(UserComment userComment){
        String no = userComment.getOrderNo();
        if(no == null || ("").equals(no)){
            throw  new BaseException("订单号不能为空", ResultCode.FAILED_CODE);
        }
        ObjectRestResponse<BaseOrder> ba = orderFeign.queryByNo(no);

        if(ba.getData() == null){
            throw  new BaseException("订单错误", ResultCode.FAILED_CODE);
        }
        BaseOrder baseOrder = ba.getData();
        if(baseOrder.getIsAppraise() == 1){
            throw  new BaseException("订单已评价，不能重复评论", ResultCode.FAILED_CODE);
        }
        JSONArray jsonArray = JSONArray.parseArray(userComment.getAppraiseJson());
        if(jsonArray == null || jsonArray.size() == 0){
            throw  new BaseException("评论维度不能为空", ResultCode.FAILED_CODE);
        }
        Integer point = 0;
        //处理维度和总分
        //[{"id":1,"name":"配送标签","point":10,"star":1},{"id":2,"name":"配送标签","point":20,"star":2}]
        for(int i =0 ;i <jsonArray.size(); i++){
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            point += jsonObject.getInteger("point");
        }
        userComment.setPoint(point);

        Integer parentId = userComment.getParentId() == null ? 0 : userComment.getParentId();
        Integer rootParentId = userComment.getRootParentId() == null ? 0 : userComment.getRootParentId();
        if (parentId > 0){
            UserComment parentComment = selectById(parentId);
            if (parentComment == null ){
                throw  new BaseException("该评论不存在", ResultCode.FAILED_CODE);
            }
            rootParentId=parentComment.getRootParentId();
            userComment.setSoureId(parentComment.getSoureId());
            userComment.setSoureUserId(parentComment.getSoureUserId());
            userComment.setSoureType(parentComment.getSoureType());
            userComment.setToUserId(parentComment.getUserId());
            userComment.setRootParentId(rootParentId);
        }else {
            if (StringUtils.isBlank(userComment.getSoureId())){
                throw  new BaseException("资源ID不能为空", ResultCode.FAILED_CODE);
            }
        }
        userComment.setCreateTime(new Date());
        insertSelective(userComment);
        Integer id = userComment.getId();
        if (id > 0 ){
            if (rootParentId == 0){
                UserComment userComment1=new UserComment();
                userComment1.setId(id);
                userComment1.setRootParentId(id);
                updateSelectiveById(userComment1);
            }else {
                mapper.addreplyNum(rootParentId);
            }
        }

        baseOrder.setIsAppraise(1);
        orderFeign.updateBaseOrder(baseOrder);
    }


}
