package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum OrderStatusEnum {
    ORDER_DEL(0, "删除订单"),
    ORDER_CRT(1, "创建订单"),
    ORDER_CANCEL(2, "取消订单"),
    ORDER_UNPAY(3, "待支付"),
    ORDER_TOSTART(4, "待进行（待出行/租车已支付）"),
    ORDER_WAIT(5, "出行中（进行中）"),
    ORDER_FINISH(6, "已完成"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    OrderStatusEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}