package com.xxfc.platform.activity.handler;


import com.alibaba.fastjson.JSONObject;
import com.xxfc.platform.activity.biz.IntegralUserRecordBiz;
import com.xxfc.platform.activity.vo.IntegralUserRecordDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class IntegralMQHandler {

    @Autowired
    IntegralUserRecordBiz integralUserRecordBiz;

    @RabbitListener(queues = "integral_queue")
    public void integralHandler(String json) {
        log.info("接收到的消息：json = {}", json);
        try{
            if(StringUtils.isNotBlank(json)) {
                IntegralUserRecordDto integralUserRecordDto = JSONObject.parseObject(json, IntegralUserRecordDto.class);
                integralUserRecordBiz.add(integralUserRecordDto);
            }
        }catch (Exception e){
            log.info("接收到的消息失败");
            e.printStackTrace();
        }

    }
}
