package com.xxfc.platform.activity.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户参与推广活动（邀请有礼）的活动记录的记录（日志）
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-05 15:23:04
 */
@Data
@Table(name = "activity_popularize_log")
public class ActivityPopularizeLog implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  描述、详情等（看情况使用）
     */
    @Column(name = "descr")
	@ApiModelProperty(value = "描述、详情等（看情况使用）")
    private String descr;
	
	    /**
     *  推广活动id
     */
    @Column(name = "popularize_id")
	@ApiModelProperty(value = "推广活动id")
    private Integer popularizeId;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  推广活动项id 
     */
    @Column(name = "item_id")
	@ApiModelProperty(value = "推广活动项id ")
    private Integer itemId;
	

}
