package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.entity.MyWalletCath;
import com.github.wxiaoqi.security.admin.mapper.MyWalletCathMapper;
import com.github.wxiaoqi.security.admin.vo.WalletCathPageVo;
import com.github.wxiaoqi.security.admin.vo.WalletCathVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 10:21
 */
@Transactional
@Service
public class MyWalletCathBiz extends BaseBiz<MyWalletCathMapper, MyWalletCath> {

    public WalletCathPageVo findWatchCatchByWithdrawalState(Integer userId,Integer state, Integer pageNo, Integer pageSize){

        WalletCathPageVo walletCathPageVo = new WalletCathPageVo();

        Example example = new Example(MyWalletCath.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("stauts",state);
        criteria.andEqualTo("userId",userId);
        PageDataVO<MyWalletCath> walletCathPage = PageDataVO.pageInfo(pageNo, pageSize, () -> mapper.selectByExample(example));

        List<MyWalletCath> walletCaths = walletCathPage.getData();
        if (CollectionUtils.isEmpty(walletCaths)){
           return walletCathPageVo;
        }

        WalletCathVo walletCathVo = null;
        BigDecimal totalWithdraw = new BigDecimal(0);
        List<WalletCathVo> walletCatchPageVos = new ArrayList<>();
        for (MyWalletCath walletCath : walletCaths) {
            walletCathVo = new WalletCathVo();
            BeanUtils.copyProperties(walletCath,walletCathVo);
            totalWithdraw = totalWithdraw.add(walletCathVo.getAmount());
            walletCatchPageVos.add(walletCathVo);
        }
        walletCathPageVo.setPageNum(walletCathPage.getPageNum());
        walletCathPageVo.setPageSize(walletCathPage.getPageSize());
        walletCathPageVo.setTotalCount(walletCathPage.getTotalCount().intValue());
        walletCathPageVo.setTotalPage(walletCathPage.getTotalPage());
        walletCathPageVo.setTotalWithdraw(totalWithdraw);
        walletCathPageVo.setWalletCaths(walletCatchPageVos);
        return walletCathPageVo;
    }

}
