package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.entity.MyWallet;
import com.github.wxiaoqi.security.admin.mapper.MyWalletMapper;
import com.github.wxiaoqi.security.admin.vo.AppletWalletVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 9:18
 */
@Transactional
@Service
public class MyWalletBiz extends BaseBiz<MyWalletMapper, MyWallet> {


       public AppletWalletVo findMyWallet(Integer userId){

           AppletWalletVo  appletWalletVo = new AppletWalletVo();

           Example example = new Example(MyWallet.class);
           Example.Criteria criteria = example.createCriteria();
           criteria.andEqualTo("userId",userId);
           List<MyWallet> wallets = mapper.selectByExample(example);

           MyWallet myWallet = wallets.get(0);
           BeanUtils.copyProperties(myWallet,appletWalletVo);
           return appletWalletVo;
       }
}
