package com.github.wxiaoqi.security.admin.dto;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 用户会员信息
 */
@Data
public class BaseUserMemberVO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     *  主键id
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 用户id
     */
    @Column(name = "user_id")
    @ApiModelProperty(value = "用户id")
    private Integer userId;

    /**
     * 会员等级
     */
    @Column(name = "member_level")
    @ApiModelProperty(value = "会员等级")
    private Integer memberLevel;



    /**
     * 赠送总天数
     */
    @Column(name = "total_number")
    @ApiModelProperty(value = "赠送总天数")
    private Integer totalNumber;

    /**
     * 剩余天数
     */
    @Column(name = "rent_free_days")
    @ApiModelProperty(value = "剩余天数")
    private Integer rentFreeDays;


    /**
     * 购买会员次数
     */
    @Column(name = "buy_count")
    @ApiModelProperty(value = "购买会员次数")
    private Integer buyCount;



    /**
     * 有效期;0代表永久
     */
    @Column(name = "valid_time")
    @ApiModelProperty(value = "有效期;0代表永久")
    private Long validTime;

    /**
     * 会员等级名称
     */
    @Column(name = "name")
    private String name;






}
