package com.xxfc.platform.vehicle.constant.ResCode;

public enum ResCode {

    AUTH_FAIL(-1,"权限验证不通过"),


    INVALID_REST_REQ_PARAM(100000,"rest请求参数非法"),


    //车辆信息相关返回码-预定信息
    VEHICLE_BOOKED_INFO_ALREADY_CHANGED(101001,"车辆预定信息已更改，请刷新后继续操作"),

    //车辆信息相关返回码-车辆信息
    VEHICLE_INFO_SAME_NUM_PLATE_EXISTS(102001,"该车牌已经存在"),
    VEHICLE_INFO_BRANCH_NOT_EXIST(102002,"分公司信息非法"),
    VEHICLE_INFO_CODE_EXIST(102003,"车辆编码已存在"),
    VEHICLE_INFO_SAME_NUM_PLATE_AND_CODE_EMPTY(102004,"车辆编码和车牌号为空"),
    VEHICLE_INFO_SAME_NUM_PLATE_AND_CODE_EXIST(102004,"车辆编码或车牌号已存在"),
    VEHICLE_INFO_IS_BOOKED(102004,"车辆已经被预定"),

    //车辆信息相关返回码-预定申请信息
    VEHICLE_BOOKED_RECORD_ALREADY_CHANGED(103001,"车辆预定申请已被审批，请刷新后继续操作"),
    VEHICLE_BOOKED_RECORD_STATUS_CHANGED(103002,"车辆预定申请状态已变更，请刷新后继续操作"),
    VEHICLE_BOOKED_RECORD_MILEAGE_CHANGED(103003,"请输入仪表盘内当前显示的公里数"),

    VEHICLE_DEPARTURE_VEHICLE_UNEXIST(104001,"车辆不存在"),
    VEHICLE_DEPARTURE_VEHICLE_DISABLE(104002,"车辆不可用"),
    VEHICLE_DEPARTURE_VEHICLE_UNDEPARTURE(104003,"车辆未出车"),

    VEHICLE_BOOK_RECORD_IS_NOT_EXIST(104004, "预约记录不存在"),

    BRANCH_COMPANY_UNEXIST(105001, "分公司信息不存在"),
    BRANCH_COMPANY_STOCK_EXISTED(105002, "分公司股权信息已存在"),
    BRANCH_COMPANY_STOCK_UNEXIST(105003, "分公司股权信息不存在"),
    BRANCH_COMPANY_STOCK_NO_BALANCE(105004, "分公司股权已售完"),
    BRANCH_COMPANY_STOCK_BALANCE_NOT_ENOUGH(105005, "分公司股权剩余份额不足"),
    BRANCH_COMPANY_STOCK_APPLY_INFO_UNEXIST(105006, "分公司股权购买申请信息不存在"),

    BRANCH_COMPANY_STOCK_APPLY_INFO_STATE_LOCKED(105007, "分公司股权购买申请信息已确认"),

    VEHICLE_UPKEEP_VEHICLE_UNEXIST(106001,"车辆不存在"),
    VEHICLE_UPKEEP_VEHICLE_DISABLE(106002,"车辆不可用"),
    VEHICLE_UPKEEP_ITEM_UNEXIST(106003, "保养项目不存在"),
    VEHICLE_UPKEEP_VEHICLE_UNUPKEEP(106004, "车辆不在保养中"),




    ;
    /**
     * 返回码
     */
    private Integer code;
    /**
     * 描述
     */
    private String desc;

    ResCode(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
