package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.OrderUserLicenseBiz;
import com.xxfc.platform.order.biz.OrderVehicleCrosstownBiz;
import com.xxfc.platform.order.entity.OrderVehicleCrosstown;
import com.xxfc.platform.order.pojo.order.OrderVehicleCrosstownDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "orderVehicle")
@Api(value = "交还车记录", tags = {"交还车记录"})
@Slf4j
public class OrderVehicleCrosstownController {

    @Autowired
    OrderVehicleCrosstownBiz orderVehicleCrosstownBiz;

    @Autowired
    OrderUserLicenseBiz orderUserLicenseBiz;

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @PostMapping(value = "/add")
    @ApiOperation(value = "添加交还车记录")
    public ObjectRestResponse<OrderVehicleCrosstownDto> add(@RequestBody OrderVehicleCrosstownDto orderVehicleCrosstownDto) {

            return orderVehicleCrosstownBiz.add(orderVehicleCrosstownDto);
    }

    @GetMapping(value = "/{id}")
    @ApiOperation(value = "查询记录信息")
    public ObjectRestResponse<OrderVehicleCrosstown> get(@PathVariable Integer id) {
        return ObjectRestResponse.succ(orderVehicleCrosstownBiz.get(id));
    }

    @GetMapping(value = "/getByOrderId")
    @ApiOperation(value = "根据订单Id获取所有记录信息")
    public ObjectRestResponse<List<OrderVehicleCrosstownDto>> getByOrderId(OrderVehicleCrosstownDto orderVehicleCrosstownDto) {
        if (orderVehicleCrosstownDto == null) {
            return ObjectRestResponse.createFailedResult(500, "参数orderId为空");
        }
        return ObjectRestResponse.succ(orderVehicleCrosstownBiz.selectByOrderId(orderVehicleCrosstownDto));
    }
    @GetMapping(value = "/getByOrderNo")
    @ApiOperation(value = "根据订单号返回交车和押金记录")
    public ObjectRestResponse getByOrderNo(String no) {
        if (no == null) {
            return ObjectRestResponse.createFailedResult(500, "参数orderId为空");
        }
        return ObjectRestResponse.succ(orderVehicleCrosstownBiz.selectByOrderNo(no));
    }

}
